#define SET_BCN_STANDBY(tm_ptr){\
    Base_tc *beacon_tc = new Short_tc;\
    beacon_tc->next_TC = NULL;\
    PUTshort_or_long(beacon_tc,SHORT_TC_CODE);\
    PUTcrc_pass(beacon_tc,0x1);\
    PUTexec_status(beacon_tc,0);\
    beacon_tc->TC_string[0] = 0x01;\
    beacon_tc->TC_string[1] = BCN_APID_SOURCE;\
    beacon_tc->TC_string[2] = BCN_SERVICE;\
    beacon_tc->TC_string[3] = 0xE2;\
    beacon_tc->TC_string[4] = 0x01;\
    beacon_tc->TC_string[5] = 0;\
    beacon_tc->TC_string[6] = 0;\
    beacon_tc->TC_string[7] = 0;\
    beacon_tc->TC_string[8] = 0;\
    uint16_t crc16 = crc16_gen(beacon_tc->TC_string, 9);\
    beacon_tc->TC_string[9]  = (crc16 & 0xFF00)>>8;\
    beacon_tc->TC_string[10] = (crc16 & 0x00FF);\
    tm_ptr =  FCTN_CDMS_RLY_TMTC(beacon_tc);\
}

#define reset_bae {\
    Base_tc *reset_BAE = new Short_tc;\
    reset_BAE->next_TC = NULL;\
    PUTshort_or_long(reset_BAE,SHORT_TC_CODE);\
    PUTcrc_pass(reset_BAE,0x1);\
    PUTexec_status(reset_BAE,0);\
    reset_BAE->TC_string[0] = 0x01;\
    reset_BAE->TC_string[1] = BAE_APID_SOURCE;\
    reset_BAE->TC_string[2] = BAE_SERVICE;\
    reset_BAE->TC_string[3] = BAE_RESET_PID;\
    reset_BAE->TC_string[4] = 0;\
    reset_BAE->TC_string[5] = 0;\
    reset_BAE->TC_string[6] = 0;\
    reset_BAE->TC_string[7] = 0;\
    reset_BAE->TC_string[8] = 0;\
    uint16_t crc16 = crc16_gen(reset_BAE->TC_string, 9);\
    reset_BAE->TC_string[9]  = (crc16 & 0xFF00)>>8;\
    reset_BAE->TC_string[10] = (crc16 & 0x00FF);\
    Base_tm *tm_ptr = new Short_tm;\
    tm_ptr =  FCTN_CDMS_RLY_TMTC(reset_BAE);\
    /*DELETE THE TM AFTER USE*/\
    Base_tm *del_tm = tm_ptr;\
    int overCount = 0;\
    while( del_tm != NULL ){\
        if( (overCount < TM_OVERFLOW_CONSTANT) ){\
            Base_tm *temp = del_tm->next_TM;\
            delete del_tm;\
            del_tm = temp;\
            ++overCount;\
        }\
        else{\
            RESET_CDMS;\
            break;\
        }\
    }\
}

#define power_off_bae {\
    Base_tc *power_off_BAE = new Short_tc;\
    power_off_BAE->next_TC = NULL;\
    PUTshort_or_long(power_off_BAE,SHORT_TC_CODE);\
    PUTcrc_pass(power_off_BAE,0x1);\
    PUTexec_status(power_off_BAE,0);\
    power_off_BAE->TC_string[0] = 0x01;\
    power_off_BAE->TC_string[1] = BAE_APID_SOURCE;\
    power_off_BAE->TC_string[2] = BAE_SERVICE;\
    power_off_BAE->TC_string[3] = BAE_POWER_OFF_PID;\
    power_off_BAE->TC_string[4] = 0;\
    power_off_BAE->TC_string[5] = 0;\
    power_off_BAE->TC_string[6] = 0;\
    power_off_BAE->TC_string[7] = 0;\
    power_off_BAE->TC_string[8] = 0;\
    uint16_t crc16 = crc16_gen(power_off_BAE->TC_string, 9);\
    power_off_BAE->TC_string[9]  = (crc16 & 0xFF00)>>8;\
    power_off_BAE->TC_string[10] = (crc16 & 0x00FF);\
    Base_tm *tm_ptr = new Short_tm;\
    tm_ptr =  FCTN_CDMS_RLY_TMTC(power_off_BAE);\
    /*DELETE THE TM AFTER USE*/\
    Base_tm *del_tm = tm_ptr;\
    int overCount = 0;\
    while( del_tm != NULL ){\
        if( (overCount < TM_OVERFLOW_CONSTANT) ){\
            Base_tm *temp = del_tm->next_TM;\
            delete del_tm;\
            del_tm = temp;\
            ++overCount;\
        }\
        else{\
            RESET_CDMS;\
            break;\
        }\
    }\
}

#define P_CDMS_HK_MAIN {\
    Base_tc *hk_main_ptr = new Short_tc;\
    hk_main_ptr->next_TC = NULL;\
    PUTshort_or_long(hk_main_ptr,SHORT_TC_CODE);\
    PUTcrc_pass(hk_main_ptr,0x1);\
    PUTexec_status(hk_main_ptr,0);\
    hk_main_ptr->TC_string[0] = 0x01;\
    hk_main_ptr->TC_string[1] = 0x81;\
    hk_main_ptr->TC_string[2] = 0x81;\
    hk_main_ptr->TC_string[3] = 0x04;\
    hk_main_ptr->TC_string[4] = 0;\
    hk_main_ptr->TC_string[5] = 0;\
    hk_main_ptr->TC_string[6] = 0;\
    hk_main_ptr->TC_string[7] = 0;\
    hk_main_ptr->TC_string[8] = 0;\
    uint16_t crc16 = crc16_gen(hk_main_ptr->TC_string, 9);\
    hk_main_ptr->TC_string[9]  = (crc16 & 0xFF00)>>8;\
    hk_main_ptr->TC_string[10] = (crc16 & 0x00FF);\
    Base_tm *tm_ptr = new Short_tm;\
    tm_ptr =  FCTN_CDMS_RLY_TMTC(hk_main_ptr);\
    /*DELETE THE TM AFTER USE*/\
    Base_tm *del_tm = tm_ptr;\
    int overCount = 0;\
    while( del_tm != NULL ){\
        if( (overCount < TM_OVERFLOW_CONSTANT) ){\
            Base_tm *temp = del_tm->next_TM;\
            delete del_tm;\
            del_tm = temp;\
            ++overCount;\
        }\
        else{\
            RESET_CDMS;\
            break;\
        }\
    }\
}

#define P_BCN_TX_MAIN(tm_ptr) {\
    Base_tc *bcn_tx_main_ptr = new Short_tc;\
    bcn_tx_main_ptr->next_TC = NULL;\
    PUTshort_or_long(bcn_tx_main_ptr,SHORT_TC_CODE);\
    PUTcrc_pass(bcn_tx_main_ptr,0x1);\
    PUTexec_status(bcn_tx_main_ptr,0);\
    bcn_tx_main_ptr->TC_string[0] = 0x01;\
    bcn_tx_main_ptr->TC_string[1] = 0x41;\
    bcn_tx_main_ptr->TC_string[2] = 0x81;\
    bcn_tx_main_ptr->TC_string[3] = 0x07;\
    bcn_tx_main_ptr->TC_string[4] = 0;\
    bcn_tx_main_ptr->TC_string[5] = 0;\
    bcn_tx_main_ptr->TC_string[6] = 0;\
    bcn_tx_main_ptr->TC_string[7] = 0;\
    bcn_tx_main_ptr->TC_string[8] = 0;\
    uint16_t crc16 = crc16_gen(bcn_tx_main_ptr->TC_string, 9);\
    bcn_tx_main_ptr->TC_string[9]  = (crc16 & 0xFF00)>>8;\
    bcn_tx_main_ptr->TC_string[10] = (crc16 & 0x00FF);\
    tm_ptr =  FCTN_CDMS_RLY_TMTC(bcn_tx_main_ptr);\
}

void COM_POWER_ON_TX() {
    if (DEBUG)
        gPC.puts("Inside COM_POWER_ON_TX\r\n");
    if( !(gFLAGS & COM_TX_FLAG) ){
        gFLAGS = gFLAGS | COM_TX_FLAG;
        if( gFLAGS & BAE_SW_EN_FLAG ){
            /*WARNING: INFINITE WHILE LOOP POSSIBLE: if standby ack received and bcn tx main status = 0*/
            bool retryFlag = true;
            while( retryFlag == true ){
                Base_tm *tm_ptr = new Short_tm;
                SET_BCN_STANDBY(tm_ptr);
                uint8_t standbyAck = 0;
                uint8_t bcn_main_status = (tm_ptr->TM_string[2] & 0xEF);
                if(( bcn_main_status == 0xC0 )||( bcn_main_status ==0xA0 ))
                    standbyAck = 1;
                if( /*standbyAck*/ true ){
                    /*ACK RECCEIVED*/
                    if( /*bcn_main_status == 0xA0*/ true ){
                        retryFlag = false;
                        RF_SW_CNTRL_TX = 1;
                        Thread::wait(25);
                        RF_SW_CNTRL_TX = 0;
                        gFLAGS = gFLAGS & (~RF_SW_STATUS_FLAG);/*RF_SW_STATUS_FLAG set to RF_COM_TX*/
                    }
                    else{
                        Thread::wait(5000);
                    }
                }
                else{
                    reset_bae;
                    Base_tm *tm_ptr2 = new Short_tm;
                    SET_BCN_STANDBY(tm_ptr2);
                    uint8_t standbyAck2 = 0;
                    uint8_t bcn_main_status2 = (tm_ptr2->TM_string[2] & 0xEF);
                    if( ( bcn_main_status2 == 0xC0 )||( bcn_main_status2 == 0xA0 ) )
                        standbyAck2 = 1;
                    if( standbyAck2 ){
                        if( bcn_main_status2 == 0xA0 ){
                            retryFlag = false;
                            RF_SW_CNTRL_TX = 1;
                            Thread::wait(25);
                            RF_SW_CNTRL_TX = 0;
                            gFLAGS = gFLAGS & (~RF_SW_STATUS_FLAG);
                        }
                        else{
                            Thread::wait(5000);
                        }\                           
                    }
                    else{
                        retryFlag = false;
                        power_off_bae;
                        gFLAGS = gFLAGS | COM_AUTO_POWER_OFF_BAE_FLAG;
                        gFLAGS = gFLAGS & (~BAE_SW_EN_FLAG);
                        RF_SW_CNTRL_TX = 1;
                        Thread::wait(25);
                        RF_SW_CNTRL_TX = 0;
                        gFLAGS = gFLAGS & (~RF_SW_STATUS_FLAG);/*RF_SW_STATUS_FLAG set to RF_COM_TX*/
                    }
                    /*DELETE THE TM AFTER USE*/
                    Base_tm *del_tm = tm_ptr2;
                    int overCount = 0;
                    while( del_tm != NULL ){
                        if( (overCount < TM_OVERFLOW_CONSTANT) ){
                            Base_tm *temp = del_tm->next_TM;
                            delete del_tm;
                            del_tm = temp;
                            ++overCount;
                        }
                        else{
                            RESET_CDMS;
                            break;
                        }
                    }
                }
                /*DELETE THE TM AFTER USE*/
                Base_tm *del_tm = tm_ptr;
                int overCount = 0;
                while( del_tm != NULL ){
                    if( (overCount < TM_OVERFLOW_CONSTANT) ){
                        Base_tm *temp = del_tm->next_TM;
                        delete del_tm;
                        del_tm = temp;
                        ++overCount;
                    }
                    else{
                        RESET_CDMS;
                        break;
                    }
                }
            }
        }
        else{
            power_off_bae;
            gFLAGS = gFLAGS & (~BAE_SW_EN_FLAG);
            RF_SW_CNTRL_TX = 1;
            Thread::wait(25);
            RF_SW_CNTRL_TX = 0;
            gFLAGS = gFLAGS & (~RF_SW_STATUS_FLAG);/*RF_SW_STATUS_FLAG set to RF_COM_TX*/
        }
    }
    //COM_TX_CNTRL = 1;
    uint8_t adfConfigPass = 0xFF;
    for( int i = 0 ; i < COM_TX_CONFIG_LIMIT ; ++i ){
        /*PENDING: CONFIGURE ADF*/
        if( adfConfigPass == 0xFF ){
            break;
        }
    }
    if( adfConfigPass == 0xFF ){
        /*adf successfully configured*/
        gFLAGS = gFLAGS | COM_TX_STATUS_FLAG;
        /*CALL SIGN*/
        Base_tm *power_on_tm = NULL;
        Base_tm *power_on_tm_head = NULL;
        get_call_sign( power_on_tm_head );
        power_on_tm = power_on_tm_head;
        /*ACK L1*/
        get_ack_l1(power_on_tm->next_TM);
        int overFlowCountADF = 0;
        while( power_on_tm->next_TM != NULL ){
            if( overFlowCountADF < TM_OVERFLOW_CONSTANT ){
                power_on_tm = power_on_tm->next_TM;
                ++overFlowCountADF;
            }
            else{
                RESET_CDMS;
                break;
            }
        }
        get_tc_list(power_on_tm->next_TM, 0x00);
        /*Call Sign, ACK_L1, TC_LIST*/
        //snd_tm.head_pointer(power_on_tm_head);
        //transmit_adf;
        uint8_t transmissionPass = 0xFF;
        /*PENDING: get acknowledgement of transmission*/
        /*deleting the telemetry*/
        power_on_tm = power_on_tm_head;
        overFlowCountADF = 0;
        while( power_on_tm != NULL ){
            if( overFlowCountADF < TM_OVERFLOW_CONSTANT ){
                Base_tm *temp = power_on_tm->next_TM;
                delete power_on_tm;
                power_on_tm = temp;
                ++overFlowCountADF;
            }
            else{
                RESET_CDMS;
                break;
            }
        }
        if( transmissionPass == 0 ){
            /*NOT Transmitted succesfully*/
            COM_POWER_OFF_TX;
            P_CDMS_HK_MAIN;
            uint8_t ackReceived = 0x00;
            Base_tm *tm_ptr = new Short_tm;
            P_BCN_TX_MAIN(tm_ptr);
            uint8_t ackcode = tm_ptr->TM_string[2] & 0xEF;
            if( (ackcode == 0xA0) || (ackcode == 0xC0))
                ackReceived = 0xFF;
            if( ackReceived == 0xFF ){
                Thread::wait(5000);
                RESET_CDMS;
            }
            else{
                RESET_CDMS;
            }
            /*DELETE THE TM AFTER USE*/
            Base_tm *del_tm = tm_ptr;
            int overCount = 0;
            while( del_tm != NULL ){
                if( (overCount < TM_OVERFLOW_CONSTANT) ){
                    Base_tm *temp = del_tm->next_TM;
                    delete del_tm;
                    del_tm = temp;
                    ++overCount;
                }
                else{
                    RESET_CDMS;
                    break;
                }
            }
        }
    }
    else{
        /*ADF not configured*/
        gFLAGS = gFLAGS & (~COM_TX_STATUS_FLAG);
        COM_POWER_OFF_TX;
        P_CDMS_HK_MAIN;
        uint8_t ackReceived = 0x00;
        Base_tm *tm_ptr = new Short_tm;
        P_BCN_TX_MAIN(tm_ptr);
        uint8_t ackcode = tm_ptr->TM_string[2] & 0xEF;
        if( (ackcode == 0xA0) || (ackcode == 0xC0))
            ackReceived = 0xFF;
        if( ackReceived == 0xFF ){
            Thread::wait(5000);
            RESET_CDMS;
        }
        else{
            RESET_CDMS;
        }
        /*DELETE THE TM AFTER USE*/
        Base_tm *del_tm = tm_ptr;
        int overCount = 0;
        while( del_tm != NULL ){
            if( (overCount < TM_OVERFLOW_CONSTANT) ){
                Base_tm *temp = del_tm->next_TM;
                delete del_tm;
                del_tm = temp;
                ++overCount;
            }
            else{
                RESET_CDMS;
                break;
            }
        }
    }
    gPC.puts("COMPLETED COM_POWER_ON_TX\r\n");
}