void FCTN_CDMS_INIT_RTC()
{
    SPI_mutex.lock();
    gCS_RTC=1;
    spi.format(8,0);
    spi.frequency(1000000);
    //clearing the halt bit
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x8C);
    spi.write(0x00);

    //clearing the OF bit
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x8F);
    spi.write(0x00);

    //century bits
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x80|0x03);
    spi.write(0x00);

    //Kick starting the oscillator
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x81); //register address with write flag
    spi.write(0x80); //enabling stop bit in the seconds register

    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x81);
    spi.write(0x00); //disabling the stop bit to restart the oscillator


    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x80);
    spi.write(0x01); // set milliseconds value to 00
    gCS_RTC=1;

    gCS_RTC=0;
    spi.write(0x81);
    spi.write(0x01); //set seconds value to 00
    gCS_RTC=1;

    gCS_RTC=0;
    spi.write(0x82);
    spi.write(0x01);//set minutes value to 00
    gCS_RTC=1;

    gCS_RTC=0;
    spi.write(0x83);
    spi.write(0x23); //set the hours to 01
    gCS_RTC=1;

    gCS_RTC=0;
    spi.write(0x84);
    spi.write(0x01); //set day of the week to 01
    gCS_RTC=1;

    gCS_RTC=0;
    spi.write(0x85);
    spi.write(0x31); //set date of the month to 01
    gCS_RTC=1;

    gCS_RTC=0;
    spi.write(0x86);
    spi.write(0x12); //set month to 01
    gCS_RTC=1;

    gCS_RTC=0;
    spi.write(0x87);
    spi.write(0x01); //set year to 00(2000)
    gCS_RTC=1;
    gPC.puts("\r\nrtc initalised\r\n");
    SPI_mutex.unlock();
}

uint64_t FCTN_CDMS_RD_RTC()
{
    SPI_mutex.lock();
    uint8_t response;

    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x0F);
    response = (spi.write(0x00))&0x04;
    
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x00);                //reading centiseconds register
    response = spi.write(0x00);     // read the value by sending dummy byte
    uint8_t centiseconds = ((response&0xF0)>>4)*10+(response&0x0F)*1;

    response =spi.write(0x00);
    uint8_t seconds = ((response&0x70)>>4)*10+(response&0x0F)*1;

    response =spi.write(0x00);
    uint8_t minutes = ((response&0x70)>>4)*10+(response&0x0F)*1;

    response=spi.write(0x00);
    uint8_t hours = ((response&0x30)>>4)*10+(response&0x0F)*1;

    uint8_t day =spi.write(0x00);

    response =spi.write(0x00);
    uint8_t date = ((response&0x30)>>4)*10+(response&0x0F)*1;

    response =spi.write(0x00);
    uint8_t month = ((response&0x10)>>4)*10+(response&0x0F)*1;

    response =spi.write(0x00);
    uint8_t year = ((response&0xF0)>>4)*10+(response&0x0F)*1;
    year = (year == 17)?0x00:(year == 18)?0x01:(year == 19)?0x02:(year == 20)?0x03:0x00;
    gCS_RTC=1;

    uint64_t time;
    time = 0;
    time = time|(((uint64_t)(centiseconds&0x7F)));
    time = time|(((uint64_t)(seconds&0x3F))<<7);
    time = time|(((uint64_t)(minutes&0x3F))<<13);
    time = time|(((uint64_t)(hours&0x1F))<<19);
    time = time|(((uint64_t)(day&0x1F))<<24);
    time = time|(((uint64_t)(month&0x07))<<29);
    time = time|(((uint64_t)(year&0x03))<<33);
    time = (time&0x00000007FFFFFFFF);

    SPI_mutex.unlock();
    return time;
}

