#define RESET_CDMS {\
    Base_tc *RESET_tc = new Short_tc;\
    RESET_tc->next_TC = NULL;\
    PUTshort_or_long(RESET_tc,SHORT_TC_CODE);\
    PUTcrc_pass(RESET_tc,0x1);\
    PUTexec_status(RESET_tc,0);\
    RESET_tc->TC_string[0] = 0x01;\
    RESET_tc->TC_string[1] = 0x81;\
    RESET_tc->TC_string[2] = 0x81;\
    RESET_tc->TC_string[3] = 0x38;\
    RESET_tc->TC_string[4] = 0;\
    RESET_tc->TC_string[5] = 0;\
    RESET_tc->TC_string[6] = 0;\
    RESET_tc->TC_string[7] = 0;\
    RESET_tc->TC_string[8] = 0;\
    uint16_t crc16 = crc16_gen(RESET_tc->TC_string, 9);\
    RESET_tc->TC_string[9]  = (crc16 & 0xFF00)>>8;\
    RESET_tc->TC_string[10] = (crc16 & 0x00FF);\
    FCTN_CDMS_RLY_TMTC(RESET_tc);\
}

#define power_on_bae {\
    Base_tc *power_on_BAE = new Short_tc;\
    power_on_BAE->next_TC = NULL;\
    PUTshort_or_long(power_on_BAE,SHORT_TC_CODE);\
    PUTcrc_pass(power_on_BAE,0x1);\
    PUTexec_status(power_on_BAE,0);\
    power_on_BAE->TC_string[0] = 0x01;\
    power_on_BAE->TC_string[1] = BAE_APID_SOURCE;\
    power_on_BAE->TC_string[2] = BAE_SERVICE;\
    power_on_BAE->TC_string[3] = BAE_POWER_ON_PID;\
    power_on_BAE->TC_string[4] = 0;\
    power_on_BAE->TC_string[5] = 0;\
    power_on_BAE->TC_string[6] = 0;\
    power_on_BAE->TC_string[7] = 0;\
    power_on_BAE->TC_string[8] = 0;\
    uint16_t crc16 = crc16_gen(power_on_BAE->TC_string, 9);\
    power_on_BAE->TC_string[9]  = (crc16 & 0xFF00)>>8;\
    power_on_BAE->TC_string[10] = (crc16 & 0x00FF);\
    Base_tm *tm_ptr = new Short_tm;\
    tm_ptr =  FCTN_CDMS_RLY_TMTC(power_on_BAE);\
    /*DELETE THE TM AFTER USE*/\
    Base_tm *del_tm = tm_ptr;\
    int overCount = 0;\
    while( del_tm != NULL ){\
        if( (overCount < TM_OVERFLOW_CONSTANT) ){\
            Base_tm *temp = del_tm->next_TM;\
            delete del_tm;\
            del_tm = temp;\
            ++overCount;\
        }\
        else{\
            RESET_CDMS;\
            break;\
        }\
    }\
}

#define resume_bcn {\
    Base_tc *beacon_tc = new Short_tc;\
    beacon_tc->next_TC = NULL;\
    PUTshort_or_long(beacon_tc,SHORT_TC_CODE);\
    PUTcrc_pass(beacon_tc,0x1);\
    PUTexec_status(beacon_tc,0);\
    beacon_tc->TC_string[0] = 0x01;\
    beacon_tc->TC_string[1] = BCN_APID_SOURCE;\
    beacon_tc->TC_string[2] = BCN_SERVICE;\
    beacon_tc->TC_string[3] = 0xE2;\
    beacon_tc->TC_string[4] = 0x00;\
    beacon_tc->TC_string[5] = 0;\
    beacon_tc->TC_string[6] = 0;\
    beacon_tc->TC_string[7] = 0;\
    beacon_tc->TC_string[8] = 0;\
    uint16_t crc16 = crc16_gen(beacon_tc->TC_string, 9);\
    beacon_tc->TC_string[9]  = (crc16 & 0xFF00)>>8;\
    beacon_tc->TC_string[10] = (crc16 & 0x00FF);\
    Base_tm *tm_ptr = new Short_tm;\
    tm_ptr =  FCTN_CDMS_RLY_TMTC(beacon_tc);\
}

#define COM_POWER_OFF_TX {\
    /*gPC.puts("Inside COM_POWER_OFF_TX\r\n");*/\
    COM_TX_CNTRL = 0;\
    RX1M.attach(&rx_read, Serial::RxIrq);\
    gFLAGS = gFLAGS & (~COM_MNG_TMTC_RUNNING_FLAG);\
    RF_SW_CNTRL_BCN = 1;\
    Thread::wait(25);\
    RF_SW_CNTRL_BCN = 0;\
    gFLAGS = gFLAGS | RF_SW_STATUS_FLAG;\
    if( gFLAGS & COM_AUTO_POWER_OFF_BAE_FLAG ){\
        power_on_bae;\
        gFLAGS = gFLAGS | BAE_SW_EN_FLAG;\
        gFLAGS & (~COM_AUTO_POWER_OFF_BAE_FLAG);\
        resume_bcn;\
    }\
    else{\
        if( gFLAGS & BAE_SW_EN_FLAG ){\
            resume_bcn;\
        }\
    }\
    gFLAGS = gFLAGS & (~COM_PA_HOT_FLAG);\
    gCOM_PA_COOLING_TIMEOUT.detach();\
    gFLAGS = gFLAGS & (~COM_TX_FLAG);\
    gFLAGS = gFLAGS & (~COM_SESSION_TIMEOUT_FLAG);\
    /*gPC.puts("completed com_power_off tx\r\n");*/\
}