#define tm_len 134
#define tc_len 135
#define tc_test_len 135

const int addr = 0x20;                                            //slave address 
bool write_ack = false;
bool read_ack = false;
const int addr_pl = 0x20<<1;  //PL address
const int addr_bae = 0x20; ///bae address
//uint8_t rcv_isr = 0;

int count = 0;

char PL_I2C_DATA[134];//Payload i2c array
uint8_t PL_TM_SIZE;//size of data to bev read from i2c
uint32_t pdirr1;
uint32_t pdirw1;

void I2C_busreset()
{
    PORTE->PCR[1] &= 0xfffffffb;    //Enabling high slew rates for SDA and SCL lines
    PORTE->PCR[0] &= 0xfffffffb;    //Enabling high slew rates for SDA and SCL lines
    I2C0->C1 &= 0x7f;               //Disabling I2C module
    SIM->SCGC4 &= 0xffffffbf;       //Disabling clock to I2C module
    SIM->SCGC4 |= 0x00000040;       //Enabling clock to I2C module
    I2C0->C1 |= 0x80;               //Enabling I2C module
    PORTE->PCR[1] |= 0x00000004;    //Disabling high slew rates for SDA and SCL lines
    PORTE->PCR[0] |= 0x00000004;    //Disabling high slew rates for SDA and SCL lines
    Thread::wait(1);                //Wait for all I2C registers to be updates to their their values
}
bool FCTN_I2C_READ_PL(char *data,int length)       // Returns 0 for success
{    
    PL_I2C_GPIO = 1;
    read_ack = master.read(addr_pl|1,data,length);
    Thread::wait(1);        //as per tests Thread::wait not required on master side. But its safe to give 1ms 
    pdirr1=PTE->PDIR;
    uint8_t i2c_count = 0;    
    if(read_ack == 0)   //if read_ack says success, it may or may not be successful.Hence we check SCL and SDA
    {
        while(((pdirr1 & 0x03000000)!=0x03000000)&& i2c_count<10)//checking SCL and SDA for time=10ms
        {
            Thread::wait(1);
            pdirr1=PTE->PDIR;
            i2c_count++;
        }
        if(((pdirr1 & 0x03000000)==0x03000000))//if SCL and SDA are both high
        {    
            gPC.printf("\n\rData received from PL");
        }
        else 
        {            
            I2C_busreset();
            read_ack = 1;
        }
    }
    else if (read_ack == 1)
    {
        CDMS_I2C_ERR_SPEED_COUNTER++;
        I2C_busreset();
    }
    
    PL_I2C_GPIO = 0;
    i2c_count = 0;
    return read_ack;
    
    
}
bool FCTN_I2C_WRITE_PL(char *data2,uint8_t tc_len2)       // Returns 0 for success
{
    write_ack = master.write(addr_pl|0x00,data2,tc_len2);//address to be defined in payload    
    Thread::wait(1);    //As per the tests Thread::wait is not required on master side but its safe to give 1ms
    pdirw1=PTE->PDIR;
    uint8_t i2c_count = 0;
    if(write_ack == 0)
    {
        while(((pdirw1 & 0x03000000)!=0x03000000)&& i2c_count<10)
        {
            Thread::wait(1);
            pdirw1=PTE->PDIR;
            i2c_count++;
        }
        if(((pdirw1 & 0x03000000)==0x03000000))
        {
            gPC.printf("\n\r Data sent");        
        }
        else
        {
            I2C_busreset();
            write_ack = 1;
        }
    }      
    if (write_ack == 1)
    {
        I2C_busreset();
        CDMS_I2C_ERR_SPEED_COUNTER++;
    }
    i2c_count = 0;
    return write_ack;
}
bool FCTN_I2C_READ(char *data,int length)       // Returns 0 for success
{   
 //   gPC.printf("i2C_rd\r\n");
    CDMS_I2C_GPIO = 1; 
    read_ack = master.read(addr_bae|1,data,length);
    Thread::wait(1);        //as per tests Thread::wait not required on master side. But its safe to give 1ms 
    pdirr1=PTE->PDIR;
    uint8_t i2c_count = 0;    
    if(read_ack == 0)   //if read_ack says success, it may or may not be successful.Hence we check SCL and SDA
    {
        while(((pdirr1 & 0x03000000)!=0x03000000)&& i2c_count<10)//checking SCL and SDA for time=10ms
        {
            Thread::wait(1);
            pdirr1=PTE->PDIR;
            i2c_count++;
        }
        if(((pdirr1 & 0x03000000)==0x03000000))//if SCL and SDA are both high
        {    
            //gPC.printf("\n\rData received from BAE");
        }
        else 
        {            
            I2C_busreset();
            read_ack = 1;
        }
    }
    else if (read_ack == 1)
    {
        I2C_busreset();
        CDMS_I2C_ERR_BAE_COUNTER++;
        
    }
 //  gPC.printf("end_12c_RD_\r\n");
    CDMS_I2C_GPIO = 0;
    i2c_count = 0;
    return read_ack;
}

bool FCTN_I2C_WRITE(char *data,int tc_len2)       // Returns 0 for success
{    
   //  gPC.printf("i2C_wr\r\n");
    CDMS_I2C_GPIO = 1;
    write_ack = master.write(addr_bae|0x00,data,tc_len2);    
    Thread::wait(1);   //As per the tests Thread::wait is not required on master side but its safe to give 1ms
    pdirw1=PTE->PDIR;
    uint8_t i2c_count = 0;
    if(write_ack == 0)
    {
        while(((pdirw1 & 0x03000000)!=0x03000000)&& i2c_count<10)
        {
            Thread::wait(1);
            pdirw1=PTE->PDIR;
            i2c_count++;
        }
        if(((pdirw1 & 0x03000000)==0x03000000))
        {
            //gPC.printf("\n\r Data sent");        
        }
        else
        {
            I2C_busreset();
            write_ack = 1;
        }
    }      
    if (write_ack == 1)
    {
        I2C_busreset();
        CDMS_I2C_ERR_BAE_COUNTER++;
    }
  //   gPC.printf("i2C_wr_end\r\n");
    CDMS_I2C_GPIO = 0;
    i2c_count = 0;
    return write_ack;
}