void FCTN_CDMS_HK_MAIN();
void FCTN_CDMS_HK();
void VERIFY_COMRX();
void VERIFY_RTC();
void CDMS_HK_SD();
void HANDLE_HW_FAULTS();
void HANDLE_HW_FAULT_SD();
void HANDLE_HW_FAULT_BAE();
void HANDLE_HW_FAULT_PL();
void FUNC_CDMS_GPIO_STATUS();
void minMaxHkData();
void COLLECT_CDMS_RAM();

extern uint8_t beacon_array[134];

AnalogIn TempInput(PIN27);          // Input from Current Multiplexer
AnalogIn CDMS_temp_sensor(PIN53);
AnalogIn COMRX_RSSI_VOLTAGE(PIN70);
AnalogIn EPS_BTRY_VOLT (PIN54);
AnalogIn BAE_CURRENT_MUX_OUT (PIN53);

DigitalOut SelectLinec3 (PIN79); // MSB of Select Lines
DigitalOut SelectLinec2 (PIN78);
// SBC V1.0
//DigitalOut SelectLinec1 (PIN76);
//DigitalOut SelectLinec0 (PIN77); // LSB of Select Lines

// SBC V2.0
DigitalOut SelectLinec1 (PIN77);
DigitalOut SelectLinec0 (PIN76); // LSB of Select Lines


Convolution CDMS_HEALTH;
Convolution BAE_HEALTH;
unsigned char CDMS_HK_FRAME[134] = {0};
char BAE_HK[134] = {0};
uint8_t convoluted_CDMS_HK[270];
uint8_t interleave_CDMS_HK[288];
uint8_t CDMS_HEALTH_FINAL[512] = {0};
uint8_t convoluted_BAE_HK[270];
uint8_t interleave_BAE_HK[288];
uint8_t BAE_HEALTH_FINAL[512] = {0};
unsigned char BAE_HK_FRAME[134] = {0};



void FCTN_CDMS_HK_MAIN(void const *args)
{
    uint8_t sd_stat = 0;
    uint8_t hk_count=0;
    while(1) {
        gPC.printf("waiting for HK sig\n\r");
        gHK_THREAD->signal_wait(HK_SIGNAL);
        gPC.printf("checking mutex in HK\n\r");
        gMutex.lock();
      SCI_LED1 =1;
        gPC.printf("locked mutex, entered in HK \n\r");
        if(hk_count == 1 || hk_count == 2) {
            FCTN_CDMS_PL_MAIN((void const *)NULL);
            hk_count--;
            gPC.printf("releasing mutex for HK_PL \n\r");
           SCI_LED1 =0;
           PL_GPIO_1_STATUS=0;
            gMutex.unlock();
            continue;
        } else if(hk_count == 0) {
            FCTN_CDMS_PL_MAIN((void const *)NULL);
            hk_count = 2;
        }
          
        //gPC.printf("\n\r%d\n",CDMS_WR_SD_FAULT_COUNTER);
        if(EN_CDMS_HK == 0x00)
            continue;
        CDMS_HK_MAIN_STATUS = 0x01;
        CDMS_HK_MAIN_COUNTER++;

       
        FCTN_CDMS_HK();         //collects temperatures
       
        if(!COM_RSSI_SET)
        {
            RSSI_VOLTAGE = COMRX_RSSI_VOLTAGE.read() * 3.3;//to be checked
        }
        else COM_RSSI_SET = 0;
        //VERIFY_COMRX();
        VERIFY_RTC();
        HANDLE_HW_FAULTS();
        FUNC_CDMS_GPIO_STATUS();

        uint8_t CDMS_quant[20];
        CDMS_quant[0]= COM_ADF_TMP+40;
        CDMS_quant[1]= (uint8_t)quant_data.CDMS_temp_quant;
        CDMS_quant[2]= (uint8_t)(RSSI_VOLTAGE*10);
        CDMS_quant[3]= (uint8_t)(EPS_BTRY_VOLT*33*(62.0/11));
        for(int i=0; i<16; i++) {
            CDMS_quant[i+4]= (uint8_t)quant_data.temp_quant[i];
        }
        minMaxHkData();

        CDMS_HEALTH_DATA[1] = GPIO_STATUS;            //Reading GPIO Pins
        CDMS_HEALTH_DATA[0] = GPIO_STATUS >> 8;
        COLLECT_CDMS_RAM();
        for(int i = 0; i<84; i++)
            CDMS_HEALTH_DATA[2+i] = CDMS_RAM[i];                  //Reading RAM parameters
        for(int i = 0; i<20; i++)                                 //Collecting Data from Temp sensors
            CDMS_HEALTH_DATA[86+i] = CDMS_quant[i];

        // Here: Have to FIT flash data.
        CDMS_HEALTH_DATA[106] = (EPS_V_A_EN_STATUS<<7) | ((BAE_STATUS<<5)&0x60) | ((SD_STATUS<<3)&0x18) | ((PL_STATUS<<1)&0x06) | (PL_EPS_LATCH_SW_EN & 0x01);
        CDMS_HEALTH_DATA[107] = (RTC_INIT_STATUS<<6) | ((CDMS_RTC_DISABLE<<5)&0x20);
        CDMS_HEALTH_DATA[108] = CDMS_RESET_COUNTER >>8;
        CDMS_HEALTH_DATA[109] = CDMS_RESET_COUNTER;
        CDMS_HEALTH_DATA[110] = TIME_LATEST_CDSMS_RESET >>24;
        CDMS_HEALTH_DATA[111] = TIME_LATEST_CDSMS_RESET >>16;
        CDMS_HEALTH_DATA[112] = TIME_LATEST_CDSMS_RESET >>8;
        CDMS_HEALTH_DATA[113] = TIME_LATEST_CDSMS_RESET;
        COM_TC_BYTES_LIMIT = BYTE_OVERFLOW_CONSTANT;
        CDMS_HEALTH_DATA[114] = COM_TC_BYTES_LIMIT>>8;
        CDMS_HEALTH_DATA[115] = COM_TC_BYTES_LIMIT;
        CDMS_HEALTH_DATA[116] = COM_RX_CURRENT_MAX;
        CDMS_HEALTH_DATA[117] = COM_RX_DISABLE_TIMEOUT;
        CDMS_HEALTH_DATA[118] = COM_PA_TMP_HIGH;
        CDMS_HEALTH_DATA[119] = COM_PA_RECOVERY_TIMEOUT;
        CDMS_HEALTH_DATA[120] = COM_SESSION_TIMEOUT/60;
        CDMS_HEALTH_DATA[121] = COM_RSSI_MIN;
        CDMS_HEALTH_DATA[122] = SD_LIB_BLK_CURRENT>>8;
        CDMS_HEALTH_DATA[122] = SD_LIB_BLK_CURRENT;

        uint32_t time = FCTN_CDMS_RD_RTC() >> 7;             //Reading Time from RTC
        for(int i = 124; i<128; i++)
            CDMS_HEALTH_DATA[i] = time >> (127-i)*8;

        gPC.printf("\t\t%d/%d/%d  ",((time & 0x003E0000)>>17),((time & 0x03C00000)>>22),((time & 0x0C000000)>>26)+2016);
        gPC.printf("%d:%d:%d\n",((time & 0x0001F000)>>12),((time & 0x00000FC0)>>6),(time & 0x0000003F));
       if(CDMS_HK_SD_DATA_READY==1||BAE_HK_SD_DATA_READY==1) 
        {
        FCTN_SD_MNGR();
        gPC.printf("endHK_SD");  
        }
  //      gPC.printf("endHK_SD");                                 //Adding FSC & TMID to TM frame
       
        CDMS_HK_FRAME[0] = 0x20;
        CDMS_HK_FRAME[1] = (FSC_CURRENT[4]+1) >> 16;
        CDMS_HK_FRAME[2] = (FSC_CURRENT[4]+1) >> 8;
        CDMS_HK_FRAME[3] = FSC_CURRENT[4]+1;
        // gPC.printf("\n");
        for(int i = 0; i<128; i++) {                      /*Adding actual CDMS Health data to TM frame*/
            CDMS_HK_FRAME[i+4] = CDMS_HEALTH_DATA[i];
            //gPC.printf("%02x",CDMS_HEALTH_DATA[i]);
        }
//   gPC.printf("\n");
        uint16_t crc = crc16_gen(CDMS_HK_FRAME,132);      /*Adding CRC to TM frame*/
        CDMS_HK_FRAME[132] = crc >> 8;
        CDMS_HK_FRAME[133] = crc;

        exor(CDMS_HK_FRAME);
        CDMS_HEALTH.convolutionEncode(CDMS_HK_FRAME , convoluted_CDMS_HK);
        CDMS_HEALTH.convolutionEncode(CDMS_HK_FRAME + 67, convoluted_CDMS_HK + 135);
        //gPC.printf("\n\r reached here");
        interleave(convoluted_CDMS_HK ,  interleave_CDMS_HK);
        interleave(convoluted_CDMS_HK +135, interleave_CDMS_HK + 144);
        //gPC.printf("\n\r reached here");
     //   gPC.printf("enterdHK_SD");
        
        if(CDMS_HK_SD_DATA_READY==1)
        {
        for(int i=0; i<288; i++)
            CDMS_HEALTH_FINAL[i] = interleave_CDMS_HK[i];
        //gPC.printf("\n\r reached here");
        sd_stat = SD_WRITE(CDMS_HEALTH_FINAL,FSC_CURRENT[4]+1,4);
        
        if(sd_stat) {
            gPC.puts("sd write failure $*&^@!~!");
        }
        }
//        }
        CDMS_HK_SD_DATA_READY=1;    
        
        // gPC.printf("Completed CDMS HK\t");

        /*---------------------------------- BAE HK --------------------------------------------*/
        
    //    gPC.printf("endHK_SD2");
        BAE_HK_I2C = FCTN_I2C_READ(BAE_HK,134);
        //  gPC.printf("\nEntering BAE HK\t");
        if(BAE_HK_I2C == 0) {
     //  gPC.printf("BAE_HK_");
            crc = crc16_gen((unsigned char *)BAE_HK,132);
            if(crc == ((uint16_t)BAE_HK[132] << 8) | (uint16_t)BAE_HK[133]) {
                gPC.printf("BAE HK data recieved through I2C\t");
                TIME_LATEST_I2C_BAE = FCTN_CDMS_RD_RTC() >> 7;
                /*for(int i = 0; i<15; i++)
                    gPC.printf("\r 0x%02X\n",BAE_HK[i]);*/
                for(int i = 0; i<4; i++)
                    BAE_HK[i] = time >> (3-i)*8;
                BAE_HK_FRAME[0] = 0x28;
                BAE_HK_FRAME[1] = (FSC_CURRENT[5]+1) >> 16;
                BAE_HK_FRAME[2] = (FSC_CURRENT[5]+1) >> 8;
                BAE_HK_FRAME[3] = FSC_CURRENT[5]+1;
                for(int i = 0; i<128; i++)                       /*Adding actual CDMS Health data to TM frame*/
                    BAE_HK_FRAME[4+i] = BAE_HK[i];
                crc = crc16_gen(BAE_HK_FRAME,132);               /*Adding CRC to TM frame*/
                BAE_HK_FRAME[132] = crc >> 8;
                BAE_HK_FRAME[133] = crc;
                for(int i =0; i <134; i++)
                {
                    gPC.printf("%02x ",BAE_HK_FRAME[i]);
                }
                exor(BAE_HK_FRAME);
                BAE_HEALTH.convolutionEncode(BAE_HK_FRAME , convoluted_BAE_HK);
                BAE_HEALTH.convolutionEncode(BAE_HK_FRAME + 67, convoluted_BAE_HK + 135);
                interleave(convoluted_BAE_HK ,  interleave_BAE_HK);
                interleave(convoluted_BAE_HK +135, interleave_BAE_HK + 144);
               
     //           gPC.printf("enterHK_SD3");
                
                if(BAE_HK_SD_DATA_READY==1)
                {
        
                for(int i=0; i<288; i++)
                    BAE_HEALTH_FINAL[i] = interleave_BAE_HK[i];
                sd_stat = SD_WRITE(BAE_HEALTH_FINAL,FSC_CURRENT[5]+1,5);
                if(sd_stat) {
                    gPC.puts("BAE_HK sd write fail");
                    //break;
                }
                }
                BAE_HK_SD_DATA_READY = 1;
    //            gPC.printf("endHK_SD4");
            }

        } else {
            gPC.printf("BAE HK data not recieved through I2C\t");
            gPC.printf("/r/n ack= %d",BAE_HK_I2C);
            for(int i = 0; i<134; i++)
                BAE_HK[i] = 0;
                
        }
        // gPC.printf("Completed BAE HK\n");

        /*----------------------------------Beacon message--------------------------------------*/


        // Add HK bits
        beacon_array[0] = 0x00;
        beacon_array[1] = time >> 32;
        beacon_array[2] = time >> 24;
        beacon_array[3] = time >> 16;
        beacon_array[4] = time >> 8;
        beacon_array[5] = time;
        beacon_array[6] = SD_FAULTCOUNT >> 8;
        beacon_array[7] = SD_FAULTCOUNT;
        beacon_array[8] = RTC_FAULTCOUNT >> 8;
        beacon_array[9] = RTC_FAULTCOUNT;
        if(!COM_OC_SET)
        beacon_array[10] = (((SD_STATUS == DEVICE_DISABLED || SD_STATUS == DEVICE_OC_FAULT)?1:0)<<7)|(RTC_STATUS <<6)|(COM_RX_STATUS<<3)|(0<<2)|(COMRX_OC_FAULT<<1)|(COM_TX_OC_FAULT);
        else
        {
            beacon_array[10] = (((SD_STATUS == DEVICE_DISABLED || SD_STATUS == DEVICE_OC_FAULT)?1:0)<<7)|(RTC_STATUS <<6)|(COM_RX_STATUS<<3)|(0<<2)|(COMRX_OC_FAULT<<1)|(com_oc_sw_status);
            COM_OC_SET = 0;
        }
        beacon_array[11] = (COM_RX_CNTRL <<7)|(COM_TX_CNTRL);
        beacon_array[12] = CDMS_HK_MAIN_COUNTER >>8;
        beacon_array[13] = CDMS_HK_MAIN_COUNTER;
        beacon_array[14] = PL_MAIN_COUNTER >>8;
        beacon_array[15] = PL_MAIN_COUNTER;
        beacon_array[16] = PL_RCV_SC_DATA_COUNTER >>8;
        beacon_array[17] = PL_RCV_SC_DATA_COUNTER;
        beacon_array[18] = TIME_LATEST_SPI_SPEED >>24;
        beacon_array[19] = TIME_LATEST_SPI_SPEED >>16;
        beacon_array[20] = TIME_LATEST_SPI_SPEED >>8;
        beacon_array[21] = TIME_LATEST_SPI_SPEED;
        beacon_array[22] = (uint8_t)(RSSI_VOLTAGE*10);

        // Add SC bits
        crc = crc16_gen(beacon_array,132);
        beacon_array[132] = crc;
        beacon_array[133] = crc >> 8;
        bool y;
        for(int i =0; i <134; i++)
        {
            gPC.printf("%02x ",beacon_array[i]);
        }
        y = FCTN_I2C_WRITE((char *)beacon_array,135);
        if(y == 0) {
            TIME_LATEST_I2C_BAE = FCTN_CDMS_RD_RTC() >> 7;
            gPC.printf("long Bcn sent\n\r");
        } else
            gPC.printf("long Bcn not sent\r\n");
        //gPC.printf("\rCompleted Beacon\n");
        gPC.printf("\rreleasing mutex for HK_MAIN \n\r");
      SCI_LED1 =0;
       gMutex.unlock();
    }
}

int quantiz(float start,float step,float x)
{
    int y=(x-start)/step;
    if(y<=0)y=0;
    if(y>=255)y=255;
    return y;
}

char saveMin(char x,char y)
{
    return (y<x)?y:x;
}

char saveMax(char x,char y)
{
    return (y>x)?y:x;
}

void minMaxHkData()
{
    MAX_COM_ADF_TMP = (MAX_COM_ADF_TMP < COM_ADF_TMP)?COM_ADF_TMP:MAX_COM_ADF_TMP;
    MIN_COM_ADF_TMP = (MIN_COM_ADF_TMP > COM_ADF_TMP)?COM_ADF_TMP:MIN_COM_ADF_TMP;
    
    MAX_RSSI_VOLTAGE = (MAX_RSSI_VOLTAGE < RSSI_VOLTAGE)?RSSI_VOLTAGE:MAX_RSSI_VOLTAGE;
    MIN_RSSI_VOLTAGE = (MIN_RSSI_VOLTAGE > RSSI_VOLTAGE)?RSSI_VOLTAGE:MIN_RSSI_VOLTAGE;
    
    if(firstCount==true) {
        for (int i = 0; i < 16; ++i) {
            min_max_data.temp_min[i] = quant_data.temp_quant[i];
            min_max_data.temp_max[i] = quant_data.temp_quant[i];
        }

        min_max_data.CDMS_temp_min=quant_data.CDMS_temp_quant;
        min_max_data.CDMS_temp_max=quant_data.CDMS_temp_quant;
    } else {
        for (int i = 0; i < 16; ++i) {
            min_max_data.temp_min[i] = saveMin(min_max_data.temp_min[i],quant_data.temp_quant[i]);
            min_max_data.temp_max[i] = saveMax(min_max_data.temp_max[i],quant_data.temp_quant[i]);
        }

        min_max_data.CDMS_temp_min = saveMin(min_max_data.CDMS_temp_min,quant_data.CDMS_temp_quant);
        min_max_data.CDMS_temp_max = saveMax(min_max_data.CDMS_temp_max,quant_data.CDMS_temp_quant);
    }
    firstCount=false;
}

void FCTN_CDMS_HK()
{

    int Iteration=0;
    float resistance;

    SelectLinec0=0;
    SelectLinec1=0;
    SelectLinec2=0;
    SelectLinec3=0;
    wait_ms(1);
    //gPC.printf("\r%d %d %d %d\n",SelectLinec3.read(),SelectLinec2.read(),SelectLinec1.read(),SelectLinec0.read());
    for(Iteration=0; Iteration<16; Iteration++) {

        actual_data.temp_actual[Iteration]=TempInput.read();

        SelectLinec0=!(SelectLinec0);
        if(Iteration%2==1)
            SelectLinec1=!(SelectLinec1);
        if(Iteration%4==3)
            SelectLinec2=!(SelectLinec2);
        if(Iteration%8==7)
            SelectLinec3=!(SelectLinec3);
        wait_ms(1);
        //  gPC.printf("\r%d %d %d %d\n",SelectLinec3.read(),SelectLinec2.read(),SelectLinec1.read(),SelectLinec0.read());
    }

    actual_data.CDMS_temp_actual=(-90.7*3.3*CDMS_temp_sensor.read())+190.1543;



    for(Iteration=0; Iteration<16; Iteration++) {

        if(Iteration<4) {
            actual_data.temp_actual[Iteration]=actual_data.temp_actual[Iteration]*3.3*2*10;
        } else if(Iteration<14) {
            resistance=22000*actual_data.temp_actual[Iteration]*3.3/(3.3-actual_data.temp_actual[Iteration]*3.3);

            if(actual_data.temp_actual[Iteration]*3.3<1.47)      //Document says 1.378 .Pls Check

                actual_data.temp_actual[Iteration]=(3694/log(24.032242*resistance))-273;
            else

                actual_data.temp_actual[Iteration]=(3365.4/log(7.60573*resistance))-273;

        } else
            actual_data.temp_actual[Iteration]=(-90.7*3.3*actual_data.temp_actual[Iteration])+190.1543;
    }
    for(Iteration=0; Iteration<16; Iteration++) {

        if(Iteration<4) {
            quant_data.temp_quant[Iteration]=actual_data.temp_actual[Iteration];
            wait(0.001);
        } else if(Iteration<14)
            quant_data.temp_quant[Iteration]=quantiz(tstart_thermistor,tstep_thermistor,actual_data.temp_actual[Iteration]);
        // quant_data.temp_quant[Iteration]=quantiz(0,1,actual_data.temp_actual[Iteration]);
        else
            // quant_data.temp_quant[Iteration]=quantiz(tstart,tstep,actual_data.temp_actual[Iteration]);
            quant_data.temp_quant[Iteration]=quantiz(tstart,tstep,actual_data.temp_actual[Iteration]);
    }
    quant_data.CDMS_temp_quant=quantiz(tstart,tstep,actual_data.CDMS_temp_actual);

    minMaxHkData();
}

void FUNC_CDMS_GPIO_STATUS()       //Polls the status of Input GPIO PINS
{
    /*
    //V_A_PGOOD //TRZ EN
    GPIO_STATUS=(V_A_PGOOD)?(GPIO_STATUS)|((uint16_t)(0x1<<15)):(GPIO_STATUS)&(~((uint16_t)(0x1<<15)));
    //V_B_PGOOD_1 //3V3BPGOOD //$
    GPIO_STATUS=(V_B_PGOOD_1)?(GPIO_STATUS)|((uint16_t)(0x1<<14)):(GPIO_STATUS)&(~((uint16_t)(0x1<<14)));
    //V_B_PGOOD_2 //3V3BEN //$
    GPIO_STATUS=(V_B_PGOOD_2)?(GPIO_STATUS)|((uint16_t)(0x1<<13)):(GPIO_STATUS)&(~((uint16_t)(0x1<<13)));
    //V_C_PGOOD //3V3CPGOOD //$
    GPIO_STATUS=(V_C_PGOOD)?(GPIO_STATUS)|((uint16_t)(0x1<<12)):(GPIO_STATUS)&(~((uint16_t)(0x1<<12)));
    */

    //COMRX_OC_FAULT //$
    GPIO_STATUS=(COMRX_OC_FAULT)?(GPIO_STATUS)|((uint16_t)(0x1<<11)):(GPIO_STATUS)&(~((uint16_t)(0x1<<11)));
    // COMTX_OC_FAULT //$
    GPIO_STATUS=(COM_TX_OC_FAULT)?(GPIO_STATUS)|((uint16_t)(0x1<<10)):(GPIO_STATUS)&(~((uint16_t)(0x1<<10)));
    // CDMS_SD_OC_FAULT
    GPIO_STATUS=(SD_OC_FAULT)?(GPIO_STATUS)|((uint16_t)(0x1<<9)):(GPIO_STATUS)&(~((uint16_t)(0x1<<9)));
    //BAE_OC_FAULT //$
    GPIO_STATUS=(BAE_OC_FAULT)?(GPIO_STATUS)|((uint16_t)(0x1<<8)):(GPIO_STATUS)&(~((uint16_t)(0x1<<8)));

    /*
    //PL_GPIO_1_STATUS //$
    GPIO_STATUS=(PL_GPIO_1_STATUS)?(GPIO_STATUS)|((uint16_t)(0x1<<8)):(GPIO_STATUS)&(~((uint16_t)(0x1<<8)));
    //PL_GPIO_2_STATUS //$
    GPIO_STATUS=(PL_GPIO_2_STATUS)?(GPIO_STATUS)|((uint16_t)(0x1<<7)):(GPIO_STATUS)&(~((uint16_t)(0x1<<7)));
    //PL_GPIO_3_STATUS //$
    GPIO_STATUS=(PL_GPIO_3_STATUS)?(GPIO_STATUS)|((uint16_t)(0x1<<6)):(GPIO_STATUS)&(~((uint16_t)(0x1<<6)));
    */

    //PL_BEE_SW_OC_FAULT //to be verified
    GPIO_STATUS=(PL_BEE_SW_OC_FAULT)?(GPIO_STATUS)|((uint16_t)(0x1<<4)):(GPIO_STATUS)&(~((uint16_t)(0x1<<4)));
    //PL_EPS_LATCH_SW_OC_FAULT // to be verified
    GPIO_STATUS=(PL_EPS_LATCH_SW_OC_FAULT)?(GPIO_STATUS)|((uint16_t)(0x1<<3)):(GPIO_STATUS)&(~((uint16_t)(0x1<<3)));
    //EPS_V_C_EN_STATUS
    GPIO_STATUS=(COM_RX_CNTRL)?(GPIO_STATUS)|((uint16_t)(0x1<<2)):(GPIO_STATUS)&(~((uint16_t)(0x1<<2)));
    //EPS_V_D_EN_STATUS
    GPIO_STATUS=(COM_TX_CNTRL)?(GPIO_STATUS)|((uint16_t)(0x1<<1)):(GPIO_STATUS)&(~((uint16_t)(0x1<<1)));
    //  gPC.printf("%04x\n",GPIO_STATUS);
    gPC.printf("\n\rBAE_OC STATE = %04x",GPIO_STATUS);
}

void VERIFY_COMRX()
{
    //COMRX_OC_FAULT //$
    if(COMRX_OC_FAULT==0 && RSSI_VOLTAGE > 0.4) {
        COMRX_STATUS = COMRX_ALIVE;
    } else {
        //RESET_COMRX();
        COMRX_RESET_COUNTER++;
        if(COMRX_OC_FAULT==0 && RSSI_VOLTAGE > 0.4)
            COMRX_STATUS = COMRX_ALIVE;
        else
            COMRX_STATUS = COMRX_DEAD;
    }
}

void VERIFY_RTC()
{
    uint8_t response;
    if(EN_RTC == 0x00)
        return;
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x0F);
    response = spi.write(0x00);
    CDMS_RTC_BL = (response & 0x10) >>4;
    if(response & 0x04 == 0x04) {
        //RESET_RTC();
        RTC_STATUS = 0x01;
        RTC_FAULTCOUNT++;
    }
    gCS_RTC=1;
}

void HANDLE_HW_FAULTS()
{
    HANDLE_HW_FAULT_SD();
    HANDLE_HW_FAULT_BAE();
    HANDLE_HW_FAULT_PL();
}

void HANDLE_HW_FAULT_SD()
{
    if(SD_STATUS != DEVICE_DISABLED) {
        if(SD_STATUS == DEVICE_OC_FAULT) {
            gPC.printf("Switching on SD card");
            SD_CARD_fromuC_ENA3 = 1; 
            SD_CARD_fromISO_ENA4 = 1;
            SD_SW_EN_DS = 1; //powering on SD
            wait_ms(10);
        }

        if(SD_OC_FAULT == 0) {
            gPC.printf("Switching off SD card");
            SD_CARD_fromuC_ENA3 = 0; 
            SD_CARD_fromISO_ENA4 = 0;
            SD_SW_EN_DS = 0; //switching off SD card
            SD_FAULTCOUNT++;
            SD_STATUS = (SD_FAULTCOUNT == 3) ? DEVICE_DISABLED :DEVICE_OC_FAULT;
            if(SD_FAULTCOUNT == 3) {
                WRITE_TO_EEPROM(2,DEVICE_DISABLED);
                gPC.printf("Declaring SD card permanantly Disabled");
            }
        } else {
            SD_STATUS = DEVICE_POWERED;
            if(SD_STATUS != DEVICE_POWERED)
                WRITE_TO_EEPROM(2,DEVICE_POWERED);
            SD_FAULTCOUNT = 0;
        }
    }
}

void HANDLE_HW_FAULT_BAE()
{
    if(BAE_STATUS != DEVICE_DISABLED) {
        if(BAE_STATUS == DEVICE_OC_FAULT) {
            gPC.printf("Switching on BAE");
            BAE_SW_EN_DS = 1; //Power ON BAE
            wait_ms(10);
        }

        if(BAE_OC_FAULT == 0) {
            gPC.printf("Switching off BAE");
            BAE_SW_EN_DS = 0; //Switch OFF BAE
            BAE_FAULTCOUNT++;
            BAE_STATUS = (BAE_FAULTCOUNT == 3)?DEVICE_DISABLED:DEVICE_OC_FAULT;
            if(BAE_FAULTCOUNT == 3) {
                WRITE_TO_EEPROM(1,DEVICE_DISABLED);
                gPC.printf("Declaring BAE permanantly Disabled");
            }
        } else {
            BAE_STATUS = DEVICE_POWERED;
            if(SD_STATUS != DEVICE_POWERED);
            WRITE_TO_EEPROM(1,DEVICE_POWERED);
            BAE_FAULTCOUNT = 0;
        }
    }
}

void HANDLE_HW_FAULT_PL()
{
    if(PL_STATUS != DEVICE_DISABLED) {
        if(PL_STATUS == DEVICE_OC_FAULT) {
            gPC.printf("Switching on PL_BEE");
            PYLD_DFF_CLK = 0;
            PYLD_DFF = 1;           // Switching ON PL
            wait_us(1);
            PYLD_DFF_CLK = 1;
            wait_us(1);
            PYLD_DFF_CLK = 0;
            wait_us(1);
        }
        if(PL_BEE_SW_OC_FAULT == 0) { // if OC Fault
            gPC.printf("Switching off PL_BEE");
            PYLD_DFF_CLK = 0;
            PYLD_DFF = 0;             //Switching OFF PL
            wait_us(1);
            PYLD_DFF_CLK = 1;
            wait_us(1);
            PYLD_DFF_CLK = 0;
            wait_us(1);
            PL_FAULTCOUNT++;
            PL_STATUS = (PL_FAULTCOUNT == 3)?DEVICE_DISABLED:DEVICE_OC_FAULT;
            if(PL_FAULTCOUNT == 3) {
                WRITE_TO_EEPROM(3,DEVICE_DISABLED);
                gPC.printf("Declaring PL_BEE permanantly Disabled");
            }
        } else {
            if(PL_STATUS == DEVICE_OC_FAULT) {
                gPC.printf("Switching off PL_BEE");
                PYLD_DFF_CLK = 0;
                PYLD_DFF = 0;             //Switching OFF PL
                wait_us(1);
                PYLD_DFF_CLK = 1;
                wait_us(1);
                PYLD_DFF_CLK = 0;
                wait_us(1);
            }
            PL_STATUS = DEVICE_ENABLED;
            if(PL_STATUS != DEVICE_ENABLED)
                WRITE_TO_EEPROM(3,DEVICE_ENABLED);
            PL_FAULTCOUNT = 0;
        }
    }
}

void COLLECT_CDMS_RAM()
{
    CDMS_RAM[0] = ((PL_INIT_STATUS<<7)&0x80)|((PL_MAIN_status<<6)&0x40)|((PL_LOW_power<<5)&0x20)|((PL_STATE<<3)&0x18)|(PL_STATUS&0x07);

    CDMS_RAM[1] = ( (PL_RCV_SC_DATA_STATUS<<7) & 0x80 )|
                  ( ((gFLAGS & COM_SESSION_FLAG)<<3) & 0x40 )|
                  ( ((gFLAGS & COM_RX_FLAG)<<1) & 0x20 )|
                  ( ((gFLAGS & RF_SW_STATUS_FLAG)>>8)&0x10 )|
                  ( ((gFLAGS & COM_TX_FLAG)>>5)&0x08 )|
                  ( (COM_TX_STATUS<<2)&0x04 )|
                  ( ((gFLAGS & COM_MNG_TMTC_RUNNING_FLAG)>>3) & 0x02 )|
                  (EN_CDMS_HK&0x01);
    CDMS_RAM[2] = ((EN_PL<<7)&0x80)|((EN_RCV_SC<<6)&0x40)|
                  ((CDMS_INIT_STATUS<<5)&0x20)|
                  ((CDMS_HK_MAIN_STATUS<<4)&0x10)|
                  ((CDMS_HK_STATUS<<2)&0x0C)|
                  ((COM_RX_STATUS<<1)&0x02)|
                  (CDMS_RTC_BL&0x01);
    CDMS_RAM[3] = CDMS_I2C_ERR_SPEED_COUNTER >> 8;
    CDMS_RAM[4] = CDMS_I2C_ERR_SPEED_COUNTER;
    CDMS_RAM[5] = CDMS_I2C_ERR_BAE_COUNTER >> 8;
    CDMS_RAM[6] = CDMS_I2C_ERR_BAE_COUNTER;
    CDMS_RAM[7] = CDMS_HK_MAIN_COUNTER >> 8;
    CDMS_RAM[8] = CDMS_HK_MAIN_COUNTER;
    CDMS_RAM[9] = PL_MAIN_COUNTER >> 8;
    CDMS_RAM[10] = PL_MAIN_COUNTER;
    CDMS_RAM[11] = PL_RCV_SC_DATA_COUNTER >> 8;
    CDMS_RAM[12] = PL_RCV_SC_DATA_COUNTER;
    CDMS_RAM[13] = COMRX_RESET_COUNTER >> 8;
    CDMS_RAM[14] = COMRX_RESET_COUNTER;
    CDMS_RAM[15] = CDMS_WR_SD_FAULT_COUNTER >> 8;
    CDMS_RAM[16] = CDMS_WR_SD_FAULT_COUNTER;
    CDMS_RAM[17] = SD_LIB_WRITES >> 8;
    CDMS_RAM[18] = SD_LIB_WRITES;
    TIME_LATEST_RTC= FCTN_CDMS_RD_RTC() >> 7; // added by samp
    for(int i = 0; i<4; i++)
        CDMS_RAM[19+i] = TIME_LATEST_RTC >> (3-i)*8;
    for(int i = 0; i<4; i++)
        CDMS_RAM[23+i] = TIME_LATEST_I2C_BAE >> (3-i)*8;
    for(int i = 0; i<4; i++)
        CDMS_RAM[27+i] = TIME_LATEST_I2C_SPEED >> (3-i)*8;
    for(int i = 0; i<4; i++)
        CDMS_RAM[31+i] = TIME_LATEST_SD_WR >> (3-i)*8;
    for(int i = 0; i<4; i++)
        CDMS_RAM[35+i] = TIME_LATEST_SD_RD >> (3-i)*8;
    for(int i = 0; i<4; i++)
        CDMS_RAM[39+i] = TIME_LATEST_SPI_SPEED >> (3-i)*8;
    for(int i = 0; i<4; i++)
        CDMS_RAM[43+i] = FSC_CURRENT[1] >> (3-i)*8;
    for(int i = 0; i<4; i++)
        CDMS_RAM[47+i] = FSC_OLD[1] >> (3-i)*8;
    for(int i = 0; i<4; i++)
        CDMS_RAM[51+i] = FSC_CURRENT[2] >> (3-i)*8;
    for(int i = 0; i<4; i++)
        CDMS_RAM[55+i] = FSC_OLD[2] >> (3-i)*8;
    for(int i = 0; i<4; i++)
        CDMS_RAM[59+i] = FSC_CURRENT[3] >> (3-i)*8;
    for(int i = 0; i<4; i++)
        CDMS_RAM[63+i] = FSC_OLD[3] >> (3-i)*8;
    for(int i = 0; i<4; i++)
        CDMS_RAM[67+i] = FSC_CURRENT[4] >> (3-i)*8;
    for(int i = 0; i<4; i++)
        CDMS_RAM[71+i] = FSC_OLD[4] >> (3-i)*8;
    for(int i = 0; i<4; i++)
        CDMS_RAM[75+i] = FSC_CURRENT[5] >> (3-i)*8;
    for(int i = 0; i<4; i++)
        CDMS_RAM[79+i] = FSC_OLD[5] >> (3-i)*8;
    CDMS_RAM[83] = 0x00;
    gPC.printf("\n\r%u %u %u %u %u",FSC_CURRENT[1],FSC_CURRENT[2],FSC_CURRENT[3],FSC_CURRENT[4],FSC_CURRENT[5]);
}