
#define RESET_CDMS NVIC_SystemReset()
#define get_tc_list(tm_ptr, thePSC){\
    uint8_t TM_PSC = 0xFF;\
    uint8_t TC_PSC = thePSC;\
    int overflowCount = 0;\
    uint8_t TC_LIST_TAG = 0x00;\
    Base_tc *temp_tc = gHEAD_NODE_TCL;\
    bool first_time = true;\
    Base_tm *current_tm = NULL;\
    while( temp_tc != NULL ){\
        if( overflowCount < TCL_OVERFLOW_CONSTANT ){\
            TM_PSC = TM_PSC + 1;\
            /*Increment TM_PSC for every new TM pointer created*/\
            Base_tm *temp_tm = new Long_tm;\
            temp_tm->next_TM = NULL;\
            temp_tm->TM_string[0] = 0x38;\
            /*Frame type(1) = 0; TMID = 0111; Spare = 000*/\
            temp_tm->TM_string[1] = TC_PSC;\
            temp_tm->TM_string[3] = TM_PSC;\
            int indexCustom = 4, num_of_short_tc = 0;\
            while(temp_tc != NULL){\
                if( overflowCount < TCL_OVERFLOW_CONSTANT ){\
                    if( GETshort_or_long_tc(temp_tc) == SHORT_TC_CODE ){\
                        for( int i = 0 ; i < TC_SHORT_SIZE ; ++i ){\
                            temp_tm->TM_string[indexCustom + i] = temp_tc->TC_string[i];\
                        }\
                        indexCustom = indexCustom + TC_SHORT_SIZE;\
                        ++overflowCount;\
                        /*INCREMENT STUFF*/\
                        temp_tc = temp_tc->next_TC;\
                        num_of_short_tc = num_of_short_tc + 1;\
                        if (temp_tc == NULL){\
                            for (int i = indexCustom ; i < TM_LONG_SIZE-2 ; ++i){\
                                temp_tm->TM_string[i] = 0;\
                                /*Fill remaining values with 0*/\
                            }\
                            TC_LIST_TAG = num_of_short_tc;\
                            break;\
                        }\
                        if( (GETshort_or_long_tc(temp_tc) == LONG_TC_CODE) || (num_of_short_tc == OBOSC_TCL_MAX_SHORT_SIZE) ){\
                            /*Next TC is long or memory is filled*/\
                            for(int i = indexCustom; i < TM_LONG_SIZE-2 ; ++i){\
                                temp_tm->TM_string[i] = 0;\
                                /*Fill remaining values with 0*/\
                            }\
                            TC_LIST_TAG = num_of_short_tc;\
                            break;\
                        }\
                    }\
                    else if (TC_LIST_TAG == OBOSC_TCL_TAG_LONG_FIRST_HALF){\
                        /*Long TC, 2nd half*/\
                        for (int i = 0; i < OBOSC_LONG_TC_SECOND_HALF_SIZE ; ++i){\
                            temp_tm->TM_string[indexCustom + i] = temp_tc->TC_string[OBOSC_LONG_TC_FIRST_HALF_SIZE + i];\
                            /*Fill the TM with TC_values*/\
                        }\
                        for (int i = OBOSC_LONG_TC_SECOND_HALF_SIZE + indexCustom ; i < TM_LONG_SIZE-2 ; ++i ){\
                            temp_tm->TM_string[i] = 0;\
                            /*Fill remaining values with 0*/\
                        }\
                        temp_tc = temp_tc->next_TC;\
                        TC_LIST_TAG = OBOSC_TCL_TAG_LONG_SECOND_HALF;\
                        ++overflowCount;\
                        break;\
                    }\
                    else{\
                        /*Long TC, 1st half */\
                        for (int i = 0; i < OBOSC_LONG_TC_FIRST_HALF_SIZE; ++i){\
                            /*gPC.printf("indexCustom = %d\r\n", indexCustom);*/\
                            temp_tm->TM_string[indexCustom + i] = temp_tc->TC_string[i];\
                            /*Fill the TM with TC_values*/\
                        }\
                        for (int i = OBOSC_LONG_TC_FIRST_HALF_SIZE + indexCustom ; i < TM_LONG_SIZE-2 ; ++i ){\
                            temp_tm->TM_string[i] = 0;\
                            /*Fill remaining values with 0*/\
                        }\
                        TC_LIST_TAG = OBOSC_TCL_TAG_LONG_FIRST_HALF;\
                        break;\
                    }\
                }\
                else{\
                    RESET_CDMS;\
                    break;\
                }\
            }\
            temp_tm->TM_string[2] = TC_LIST_TAG;\
            /*TC_LIST_TAG as is updated in the inner while loop*/\
            uint16_t crc16 = crc16_gen(temp_tm->TM_string, TM_LONG_SIZE-2);\
            temp_tm->TM_string[TM_LONG_SIZE-2] = (crc16 & 0xFF00) >> 8 ;\
            temp_tm->TM_string[TM_LONG_SIZE-1] = crc16 & 0x00FF;\
            /*Attach this new node to the TM linked list*/\
            if( first_time ){\
                first_time = false;\
                tm_ptr = temp_tm;\
                current_tm = temp_tm;\
            }\
            else{\
                current_tm->next_TM = temp_tm;\
                current_tm = current_tm->next_TM;\
            }\
            /*Attach this new node at the end*/\
        }\
        else{\
            RESET_CDMS;\
            break;\
        }\
    }\
}

#define put_crc_l1_ack(tm_ptr) {\
    /*TC LIST STATUS*/\
    tm_ptr->TM_string[3] |= (gMASTER_STATE << 6) & 0xC0;\
    /*PA HOT*/\
    if( gFLAGS & COM_PA_HOT_FLAG ){\
        tm_ptr->TM_string[3] |= (1 << 5);\
    }\
    else{\
        tm_ptr->TM_string[3] &= ~(1 << 5);\
    }\
    /*PA OC*/\
    if( gFLAGS & COM_PA_OC_FLAG ){\
        tm_ptr->TM_string[3] |= (1 << 4);\
    }\
    else{\
        tm_ptr->TM_string[3] &= ~(1 << 4);\
    }\
    uint16_t crc_checksum = crc16_gen(tm_ptr->TM_string, TM_SHORT_SIZE-2);\
    tm_ptr->TM_string[TM_SHORT_SIZE-2] = (crc_checksum >> 8) & 0xFF;\
    tm_ptr->TM_string[TM_SHORT_SIZE-1] = crc_checksum & 0xFF;\
}

#define fill_l1_ack(tm_ptr) {\
    tm_ptr->next_TM = NULL;\
    tm_ptr->TM_string[0] = TMID_ACK_L1 << 4;\
    tm_ptr->TM_string[1] = gTOTAL_INCORRECT_SIZE_TC & 0xFF;\
    tm_ptr->TM_string[2] = gTOTAL_CRC_FAIL_TC & 0xFF;\
}

#define P_COM_HK{\
    uint8_t returnHere;\
    isPAhot(returnHere);\
    if (returnHere == 0xFF)\
        gFLAGS = gFLAGS | COM_PA_HOT_FLAG;\
    else\
        gFLAGS = gFLAGS & ~(COM_PA_HOT_FLAG);\        
    if (gFLAGS & COM_PA_OC_FLAG){\
        COM_TX_CNTRL = 1;\
        COM_DATA_fromuC_ENAIN = 1;\
        COM_DATA_fromISO_ENAOUT=1;\
        wait_ms(5);\
    }\
    isPAoc(returnHere);\
    if (returnHere == 0xFF)\
        gFLAGS = gFLAGS | COM_PA_OC_FLAG;\
    else\
        gFLAGS = gFLAGS & ~(COM_PA_OC_FLAG);\
    /*P_CDMS_HANDLE_HW_FAULTS*/\
}

#define isPAhot(returnHere){\
    uint8_t pa_temp = 0;\
    SelectLinec0=0;\
    SelectLinec1=0;\
    SelectLinec2=0;\
    SelectLinec3=1;\
    pa_temp = TempInput.read();\
    pa_temp = pa_temp * 3.3;\
    float resistance;\
    resistance = 24000 * pa_temp/(3.3 - pa_temp);\
    if(pa_temp > 1.47) {\
        pa_temp = 3694/log(24.032242*resistance);\
    }\
    else{\
        pa_temp = 3365.4/log(7.60573*resistance);\
    }\
    COM_PA_IC_TMP = quantiz(tstart_thermistor,tstep_thermistor,pa_temp);\
    /*comment this ater*/\
    COM_PA_IC_TMP = 0;\
    /*COM_PA_TMP_HIGH to be found*/\
    if (COM_PA_IC_TMP > COM_PA_TMP_HIGH){\
        returnHere = 0xFF;\
        gPC.puts("PA is measured HOT\r\n");\
    }\
    else{\
        returnHere = 0;\
        gPC.puts("PA is measured not HOT\r\n");\
    }\
}

#define isPAoc(returnHere){\
    if (!com_oc_sw_status){\
        returnHere = 0xFF;\
    }\
    else{\
        returnHere = 0;\
    }\
}

#define get_call_sign(tm_ptr) {\
    Base_tm* call_sign_tm = new Short_tm;\
    call_sign_tm->next_TM = NULL;\
    tm_ptr = call_sign_tm;\
    for( int i = 0 ; i < TM_SHORT_SIZE ; ++i ){\
        call_sign_tm->TM_string[i] = gCALL_SIGN_STRING[i];\
    }\
}

#define get_ack_l1( tm_ptr ){\
    Base_tc *current_TC = gHEAD_NODE_TCL;\
    Base_tm *l1_ack = new Short_tm;\
    /*APPEND TO THE tm_ptr HERE*/\
    tm_ptr = l1_ack;\
    fill_l1_ack(l1_ack);\
    int TC_count = 0;\
    int overflowCountL1 = 0;\
    while(current_TC != NULL){\
        if( overflowCountL1 < TCL_OVERFLOW_CONSTANT ){\
            /*IF CRC PASS*/\
            if( (GETcrc_pass(current_TC) == 1) ){\
                if(TC_count > 4){\
                    put_crc_l1_ack( l1_ack );\
                    /*extend the TM linked list*/\
                    TC_count = 0;\
                    l1_ack->next_TM = new Short_tm;\
                    l1_ack = l1_ack->next_TM;\
                    fill_l1_ack(l1_ack);\
                }\
                /*PSC starts from 7th byte*/\
                l1_ack->TM_string[6+TC_count] = GETpacket_seq_count(current_TC);\
                /*TC exec status*/\
                switch(TC_count){\
                    case 0:\
                        l1_ack->TM_string[3] = (GETexec_status(current_TC)) & 0x0F;\
                        break;\
                    case 1:\
                        l1_ack->TM_string[4] = (GETexec_status(current_TC) << 4) & 0xF0;\
                        break;\
                    case 2:\
                        l1_ack->TM_string[4] |= (GETexec_status(current_TC)) & 0x0F;\
                        break;\
                    case 3:\
                        l1_ack->TM_string[5] = (GETexec_status(current_TC) << 4) & 0xF0;\
                        break;\
                    case 4:\
                        l1_ack->TM_string[5] |= (GETexec_status(current_TC)) & 0x0F;\
                }\
                ++TC_count;\
            }\
            current_TC = current_TC->next_TC;\
            ++overflowCountL1;\
        }\
        else{\
            RESET_CDMS;\
            break;\
        }\
    }\
    /*FILL UP THE REMAINING FIELDS WITH 0x00 as PSC, AND 0xF as tc exec status*/\
    if( (TC_count < 5) && (TC_count != 0) ){\
        while(TC_count < 5){\
            l1_ack->TM_string[6+TC_count] = 0x00;\
            switch(TC_count){\
                case 1:\
                    l1_ack->TM_string[4] = 0xF0;\
                    break;\
                case 2:\
                    l1_ack->TM_string[4] |= 0x0F;\
                    break;\
                case 3:\
                    l1_ack->TM_string[5] = 0xF0;\
                    break;\
                case 4:\
                    l1_ack->TM_string[5] |= 0x0F;\
            }\
            ++TC_count;\
        }\
    }\
    put_crc_l1_ack(l1_ack);\
}