// problem in check pa and valid sid not sending anything in one for loop

#ifndef OBSRS_H    // To make sure you don't declare the function more than once by including the header multiple times.
#define OBSRS_H

// no error            case 2 ackl234new->TM_string[2] = (101_0000) = 0x_0;     spare = 0  10100000 =  0xA0
// Hardware failure    Case 4 ackl234new->TM_string[2] = (100_0101) = 0x_5;     spare = 0  10000101 =  0x85 comes from cdms ask pradeep
// Invalid FSC         Case 4 ackl234new->TM_string[2] = (100_0110) = 0x_6;     spare = 0  10000110 =  0x86 Invalid FSC
// Illegal TC          Case 3 ackl234new->TM_string[2] = (000_0010) = 0x_2;     spare = 0  00000010 =  0x02 invalid SID

#define TMID_ACK_L234 0xB
#define T_frames_in_segment 40

using namespace std;
Base_tc *current_obsrs_tc = NULL;   
Base_tm *callsign = NULL;
bool send_EoS_and_stop = false;
bool adf_limit = false;
bool stop = false;
bool PA_HOT=0;
bool short_TC;
bool valid_SID = true;
bool enable_call_sign = true;
bool enable_new_segment=true;
bool enable_S_frame = true;
bool enable_read_block = false;
bool enable_T_frame = false;
bool enable_Ack_andcallsign = false;
bool enable_ackandcallsign = false;
bool new_session =true;
bool enable_EoS=false;
bool create_Ack_andcallsign = true;
bool Ack_andcallsign_over = false;
bool repeat_last_2T_frames = false;
bool last_block = false;
bool new_OBSRS_TC = true;
bool enable_SCH = true;
bool enable_FCCH = false;
bool enable_DS = false;
bool half_buffer = 0;
bool TM_sent = false;
//bool session_over = gFLAGS & COM_SESSION_TIMEOUT_FLAG;

uint8_t SID ;
uint32_t FSC;
uint16_t read_success = false;
uint16_t counter_buffer_112=0, counter_EoS=0,T_frames_sent=0;
uint16_t counter_interleavedata=0;
uint16_t counter_buffer_512=0;
uint16_t max_segments  =  65415/(48+T_frames_in_segment*159);
uint16_t ack_code = 0xA0;
uint8_t segments_sent = 0;
uint8_t counter_SCH40 = 0;
uint8_t counter_FCCH80 = 0;
uint8_t counter_S_frame = 0;
uint8_t T_frame_Ack_andcallsign_sent = 0; 
uint8_t T_frame_in_Ackandcallsign ;                        // needs to get from sukhdeep depends on size of Ack_L1
uint32_t block_counter = 0;
uint16_t no_of_frames =0;                             

//#define max_segments = 65415/(48+T_frames_in_segment*159)
// data 288 byte with convolution without xoring 0x38,0x90,0x7B,0x40,0x01,0x56,0x45,0xE0,0x3C,0xA0,0x7A,0x90,0x3D,0xE6,0x3E,0x70,0x21,0x42,0x43,0x3C,0x0C,0x20,0x00,0x4C,0x83,0x12,0x67,0xF0,0x8F,0x36,0x60,0x3C,0x86,0x24,0x06,0x80,0x20,0x54,0x22,0x9C,0x07,0x2A,0x00,0x8C,0x0F,0x7A,0x25,0x50,0x88,0x50,0x5F,0x8C,0xAB,0x0A,0x7A,0xCC,0x10,0xC4,0x25,0x10,0xB3,0xCE,0x5F,0x40,0xA1,0x8A,0x05,0xD0,0x90,0x14,0x7E,0x00,0x09,0xCA,0x7F,0xA0,0x1B,0xDE,0x00,0x70,0x12,0x14,0x7D,0x50,0x2A,0xC0,0x7D,0x20,0x14,0x30,0x04,0x4C,0x3C,0xF0,0x02,0xEC,0x28,0x60,0x45,0xA0,0x04,0x04,0x47,0x1C,0x22,0x70,0x02,0xE0,0x26,0xF4,0x41,0xFC,0x04,0x84,0x04,0x9C,0x0A,0xB0,0x41,0x40,0x25,0x0C,0xBF,0x9C,0x2F,0x3C,0xF8,0x5C,0x0A,0x18,0x4A,0xC0,0x21,0x00,0xB2,0x80,0x58,0x9C,0x8A,0x00,0x79,0xBC,0x7D,0x00,0x10,0x28,0x3E,0x3C,0x46,0x94,0x7D,0xB8,0x21,0x20,0x42,0x04,0x77,0xB4,0xB7,0x84,0x53,0x94,0x03,0xA0,0x20,0x08,0xF4,0x00,0x47,0x34,0xF7,0x60,0x63,0x3C,0x01,0xC0,0x24,0x08,0xF3,0xA0,0x11,0xA0,0xF3,0x60,0x68,0x48,0x08,0xB8,0x7D,0xE8,0x0D,0xF8,0x14,0xE0,0x83,0xC0,0x48,0x00,0x8E,0xB8,0x91,0xC8,0x05,0x40,0xD8,0xC8,0x8B,0xF8,0xC9,0x00,0x0D,0x38,0x04,0x68,0x86,0x80,0x9A,0x11,0x7B,0xB8,0x9F,0x79,0xF8,0x38,0x05,0x38,0x99,0x80,0xD2,0x01,0x69,0x80,0x24,0x71,0x14,0x80,0xF6,0x30,0xFE,0x80,0x72,0x41,0xE9,0x00,0x01,0x19,0x17,0x80,0xE6,0x81,0xEA,0x40,0x67,0xD8,0xFD,0xC0,0x81,0x48,0x1E,0xF0,0x34,0x81,0x13,0x30,0x09,0x19,0x8D,0xC8,0xBD,0x88,0x84,0xF8,0x9C,0x90,0x1C,0x00,0x00,0x41,0x8C,0x78,0x39,0xA9,0x12,0x30,0x19,0xF8,0x87,0x48
// actual data 0x18,0x00,0x00,0x00,0x1C,0x44,0x10,0x04,0x01,0xE0,0x44,0x10,0x04,0x01,0xE0,0x44,0x10,0x04,0x01,0xE0,0x44,0x10,0x04,0x01,0xE0,0x44,0x10,0x04,0x01,0xE0,0x44,0x10,0x40,0x00,0x00,0x00,0x00,0x01,0x40,0x82,0x41,0x20,0x10,0x08,0x04,0x02,0x01,0xE4,0x3A,0x28,0x22,0x3A,0x28,0x22,0x3A,0x28,0x22,0x41,0x10,0x04,0x01,0xE4,0x40,0x20,0x10,0x08,0x04,0x01,0xE4,0x41,0x10,0x04,0x01,0xE4,0x41,0x10,0x04,0x01,0xE4,0x41,0x10,0x04,0x01,0xE4,0x41,0x10,0x04,0x01,0xE4,0x41,0x10,0x04,0x01,0xE4,0x41,0x10,0x40,0x00,0x00,0x00,0x00,0x01,0x48,0x82,0x41,0x20,0x10,0x08,0x04,0x02,0x01,0xE8,0x04,0x28,0x22,0x04,0x28,0x22,0x04,0x28,0x22,0x42,0x10,0x04,0x01,0xE8,0x40,0x20,0x10,0x08,0x04,0x01,0x00,0x00,
//const unsigned char S_frame[] = {0x46,0x9D,0xFB,0xF0,0xD2,0xBA,0x89,0xE4,0x46,0x9D,0xFB,0xF0,0xD2,0xBA,0x89,0xE4,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
//const unsigned char EoS[] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x1A,0x77,0xEF,0xC3,0x4A,0xEA,0x27,0x91,0x1A,0x77,0xEF,0xC3,0x4A,0xEA,0x27,0x90,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x1A,0x77,0xEF,0xC3,0x4A,0xEA,0x27,0x91,0x1A,0x77,0xEF,0xC3,0x4A,0xEA,0x27,0x90,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
//unsigned char call_sign_buffer[318]={0x0A,0x3F,0x46,0xB4,0x00,0x38,0x90,0x7B,0x40,0x01,0x56,0x45,0xE0,0x3C,0xA0,0x7A,0x90,0x3D,0xE6,0x3E,0x70,0x21,0x42,0x43,0x3C,0x0C,0x20,0x00,0x4C,0x83,0x12,0x67,0xF0,0x8F,0x36,0x60,0x3C,0x86,0x24,0x06,0x80,0x20,0x54,0x22,0x9C,0x07,0x2A,0x00,0x8C,0x0F,0x7A,0x25,0x50,0x88,0x50,0x5F,0x8C,0xAB,0x0A,0x7A,0xCC,0x10,0xC4,0x25,0x10,0xB3,0xCE,0x5F,0x40,0xA1,0x8A,0x05,0xD0,0x90,0x14,0x7E,0x00,0x09,0xCA,0x7F,0xA0,0x1B,0xDE,0x00,0x70,0x12,0x14,0x7D,0x50,0x2A,0xC0,0x7D,0x20,0x14,0x30,0x04,0x4C,0x3C,0xF0,0x02,0xEC,0x28,0x60,0x45,0xA0,0x04,0x04,0x47,0x1C,0x22,0x70,0x02,0xE0,0x26,0xF4,0x41,0xFC,0x04,0x84,0x04,0x9C,0x0A,0xB0,0x41,0x40,0x25,0x0C,0xBF,0x9C,0x2F,0x3C,0xF8,0x5C,0x0A,0x18,0x4A,0xC0,0x21,0x00,0xB2,0x80,0x58,0x9C,0x8A,0x00,0x79,0xBC,0x7D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0x3F,0x46,0xB4,0x00,0x10,0x28,0x3E,0x3C,0x46,0x94,0x7D,0xB8,0x21,0x20,0x42,0x04,0x77,0xB4,0xB7,0x84,0x53,0x94,0x03,0xA0,0x20,0x08,0xF4,0x00,0x47,0x34,0xF7,0x60,0x63,0x3C,0x01,0xC0,0x24,0x08,0xF3,0xA0,0x11,0xA0,0xF3,0x60,0x68,0x48,0x08,0xB8,0x7D,0xE8,0x0D,0xF8,0x14,0xE0,0x83,0xC0,0x48,0x00,0x8E,0xB8,0x91,0xC8,0x05,0x40,0xD8,0xC8,0x8B,0xF8,0xC9,0x00,0x0D,0x38,0x04,0x68,0x86,0x80,0x9A,0x11,0x7B,0xB8,0x9F,0x79,0xF8,0x38,0x05,0x38,0x99,0x80,0xD2,0x01,0x69,0x80,0x24,0x71,0x14,0x80,0xF6,0x30,0xFE,0x80,0x72,0x41,0xE9,0x00,0x01,0x19,0x17,0x80,0xE6,0x81,0xEA,0x40,0x67,0xD8,0xFD,0xC0,0x81,0x48,0x1E,0xF0,0x34,0x81,0x13,0x30,0x09,0x19,0x8D,0xC8,0xBD,0x88,0x84,0xF8,0x9C,0x90,0x1C,0x00,0x00,0x41,0x8C,0x78,0x39,0xA9,0x12,0x30,0x19,0xF8,0x87,0x48,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
    //0x00,0x0A,0x3F,0x46,0xB4,0x00,0x38,0x90,0x7B,0x40,0x01,0x56,0x45,0xE0,0x3C,0xA0,0x7A,0x90,0x3D,0xE6,0x3E,0x70,0x21,0x42,0x43,0x3C,0x0C,0x20,0x00,0x4C,0x83,0x12,0x67,0xF0,0x8F,0x36,0x60,0x3C,0x86,0x24,0x06,0x80,0x20,0x54,0x22,0x9C,0x07,0x2A,0x00,0x8C,0x0F,0x7A,0x25,0x50,0x88,0x50,0x5F,0x8C,0xAB,0x0A,0x7A,0xCC,0x10,0xC4,0x25,0x10,0xB3,0xCE,0x5F,0x40,0xA1,0x8A,0x05,0xD0,0x90,0x14,0x7E,0x00,0x09,0xCA,0x7F,0xA0,0x1B,0xDE,0x00,0x70,0x12,0x14,0x7D,0x50,0x2A,0xC0,0x7D,0x20,0x14,0x30,0x04,0x4C,0x3C,0xF0,0x02,0xEC,0x28,0x60,0x45,0xA0,0x04,0x04,0x47,0x1C,0x22,0x70,0x02,0xE0,0x26,0xF4,0x41,0xFC,0x04,0x84,0x04,0x9C,0x0A,0xB0,0x41,0x40,0x25,0x0C,0xBF,0x9C,0x2F,0x3C,0xF8,0x5C,0x0A,0x18,0x4A,0xC0,0x21,0x00,0xB2,0x80,0x58,0x9C,0x8A,0x00,0x79,0xBC,0x7D,0x00,0x10,0x28,0x3E,0x3C,0x46,0x94,0x7D,0xB8,0x21,0x20,0x42,0x04,0x77,0xB4,0xB7,0x84,0x53,0x94,0x03,0xA0,0x20,0x08,0xF4,0x00,0x47,0x34,0xF7,0x60,0x63,0x3C,0x01,0xC0,0x24,0x08,0xF3,0xA0,0x11,0xA0,0xF3,0x60,0x68,0x48,0x08,0xB8,0x7D,0xE8,0x0D,0xF8,0x14,0xE0,0x83,0xC0,0x48,0x00,0x8E,0xB8,0x91,0xC8,0x05,0x40,0xD8,0xC8,0x8B,0xF8,0xC9,0x00,0x0D,0x38,0x04,0x68,0x86,0x80,0x9A,0x11,0x7B,0xB8,0x9F,0x79,0xF8,0x38,0x05,0x38,0x99,0x80,0xD2,0x01,0x69,0x80,0x24,0x71,0x14,0x80,0xF6,0x30,0xFE,0x80,0x72,0x41,0xE9,0x00,0x01,0x19,0x17,0x80,0xE6,0x81,0xEA,0x40,0x67,0xD8,0xFD,0xC0,0x81,0x48,0x1E,0xF0,0x34,0x81,0x13,0x30,0x09,0x19,0x8D,0xC8,0xBD,0x88,0x84,0xF8,0x9C,0x90,0x1C,0x00,0x00,0x41,0x8C,0x78,0x39,0xA9,0x12,0x30,0x19,0xF8,0x87,0x48,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
uint8_t buffer_512[512]; 
//unsigned char Ack_andcallsign[318]={0x0A,0x3F,0x46,0xB4,0x00,0x38,0x90,0x7B,0x40,0x01,0x56,0x45,0xE0,0x3C,0xA0,0x7A,0x90,0x3D,0xE6,0x3E,0x70,0x21,0x42,0x43,0x3C,0x0C,0x20,0x00,0x4C,0x83,0x12,0x67,0xF0,0x8F,0x36,0x60,0x3C,0x86,0x24,0x06,0x80,0x20,0x54,0x22,0x9C,0x07,0x2A,0x00,0x8C,0x0F,0x7A,0x25,0x50,0x88,0x50,0x5F,0x8C,0xAB,0x0A,0x7A,0xCC,0x10,0xC4,0x25,0x10,0xB3,0xCE,0x5F,0x40,0xA1,0x8A,0x05,0xD0,0x90,0x14,0x7E,0x00,0x09,0xCA,0x7F,0xA0,0x1B,0xDE,0x00,0x70,0x12,0x14,0x7D,0x50,0x2A,0xC0,0x7D,0x20,0x14,0x30,0x04,0x4C,0x3C,0xF0,0x02,0xEC,0x28,0x60,0x45,0xA0,0x04,0x04,0x47,0x1C,0x22,0x70,0x02,0xE0,0x26,0xF4,0x41,0xFC,0x04,0x84,0x04,0x9C,0x0A,0xB0,0x41,0x40,0x25,0x0C,0xBF,0x9C,0x2F,0x3C,0xF8,0x5C,0x0A,0x18,0x4A,0xC0,0x21,0x00,0xB2,0x80,0x58,0x9C,0x8A,0x00,0x79,0xBC,0x7D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0x3F,0x46,0xB4,0x00,0x10,0x28,0x3E,0x3C,0x46,0x94,0x7D,0xB8,0x21,0x20,0x42,0x04,0x77,0xB4,0xB7,0x84,0x53,0x94,0x03,0xA0,0x20,0x08,0xF4,0x00,0x47,0x34,0xF7,0x60,0x63,0x3C,0x01,0xC0,0x24,0x08,0xF3,0xA0,0x11,0xA0,0xF3,0x60,0x68,0x48,0x08,0xB8,0x7D,0xE8,0x0D,0xF8,0x14,0xE0,0x83,0xC0,0x48,0x00,0x8E,0xB8,0x91,0xC8,0x05,0x40,0xD8,0xC8,0x8B,0xF8,0xC9,0x00,0x0D,0x38,0x04,0x68,0x86,0x80,0x9A,0x11,0x7B,0xB8,0x9F,0x79,0xF8,0x38,0x05,0x38,0x99,0x80,0xD2,0x01,0x69,0x80,0x24,0x71,0x14,0x80,0xF6,0x30,0xFE,0x80,0x72,0x41,0xE9,0x00,0x01,0x19,0x17,0x80,0xE6,0x81,0xEA,0x40,0x67,0xD8,0xFD,0xC0,0x81,0x48,0x1E,0xF0,0x34,0x81,0x13,0x30,0x09,0x19,0x8D,0xC8,0xBD,0x88,0x84,0xF8,0x9C,0x90,0x1C,0x00,0x00,0x41,0x8C,0x78,0x39,0xA9,0x12,0x30,0x19,0xF8,0x87,0x48,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
uint32_t list_of_FSC[43]={0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x40,0x41,0x42,0x43};
uint8_t write_buffer[512] = {0x38,0x90,0x7B,0x40,0x01,0x56,0x45,0xE0,0x3C,0xA0,0x7A,0x90,0x3D,0xE6,0x3E,0x70,0x21,0x42,0x43,0x3C,0x0C,0x20,0x00,0x4C,0x83,0x12,0x67,0xF0,0x8F,0x36,0x60,0x3C,0x86,0x24,0x06,0x80,0x20,0x54,0x22,0x9C,0x07,0x2A,0x00,0x8C,0x0F,0x7A,0x25,0x50,0x88,0x50,0x5F,0x8C,0xAB,0x0A,0x7A,0xCC,0x10,0xC4,0x25,0x10,0xB3,0xCE,0x5F,0x40,0xA1,0x8A,0x05,0xD0,0x90,0x14,0x7E,0x00,0x09,0xCA,0x7F,0xA0,0x1B,0xDE,0x00,0x70,0x12,0x14,0x7D,0x50,0x2A,0xC0,0x7D,0x20,0x14,0x30,0x04,0x4C,0x3C,0xF0,0x02,0xEC,0x28,0x60,0x45,0xA0,0x04,0x04,0x47,0x1C,0x22,0x70,0x02,0xE0,0x26,0xF4,0x41,0xFC,0x04,0x84,0x04,0x9C,0x0A,0xB0,0x41,0x40,0x25,0x0C,0xBF,0x9C,0x2F,0x3C,0xF8,0x5C,0x0A,0x18,0x4A,0xC0,0x21,0x00,0xB2,0x80,0x58,0x9C,0x8A,0x00,0x79,0xBC,0x7D,0x00,0x10,0x28,0x3E,0x3C,0x46,0x94,0x7D,0xB8,0x21,0x20,0x42,0x04,0x77,0xB4,0xB7,0x84,0x53,0x94,0x03,0xA0,0x20,0x08,0xF4,0x00,0x47,0x34,0xF7,0x60,0x63,0x3C,0x01,0xC0,0x24,0x08,0xF3,0xA0,0x11,0xA0,0xF3,0x60,0x68,0x48,0x08,0xB8,0x7D,0xE8,0x0D,0xF8,0x14,0xE0,0x83,0xC0,0x48,0x00,0x8E,0xB8,0x91,0xC8,0x05,0x40,0xD8,0xC8,0x8B,0xF8,0xC9,0x00,0x0D,0x38,0x04,0x68,0x86,0x80,0x9A,0x11,0x7B,0xB8,0x9F,0x79,0xF8,0x38,0x05,0x38,0x99,0x80,0xD2,0x01,0x69,0x80,0x24,0x71,0x14,0x80,0xF6,0x30,0xFE,0x80,0x72,0x41,0xE9,0x00,0x01,0x19,0x17,0x80,0xE6,0x81,0xEA,0x40,0x67,0xD8,0xFD,0xC0,0x81,0x48,0x1E,0xF0,0x34,0x81,0x13,0x30,0x09,0x19,0x8D,0xC8,0xBD,0x88,0x84,0xF8,0x9C,0x90,0x1C,0x00,0x00,0x41,0x8C,0x78,0x39,0xA9,0x12,0x30,0x19,0xF8,0x87,0x48,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
//const unsigned char EXOR_SEQ[] = {0x55,0xF1,0x51,0x3D,0xA7,0x42,0xAE,0x2E,0x2E,0x28,0x76,0x80,0x62,0x41,0xC4,0x75,0x4D,0x87,0xDB,0xE1,0x02,0x61,0x60,0x96,0x9C,0xCB,0x8A,0xBD,0x37,0xE4,0x72,0x5D,0xF2,0x19,0x62,0x06,0x9A,0xF9,0x38,0xB0,0x49,0x75,0xD0,0x17,0x1B,0xCC,0x0B,0xEB,0x1B,0x50,0xA2,0x2A,0x8E,0xFA,0x4D,0x6F,0x1B,0xF8,0x0F,0x97,0x39,0x25,0x60,0x55,0x9A,0xDF,0x1D,0x10,0x7F,0xBD,0x3E,0xBF,0xE5,0x68,0x02,0xD1,0x99,0x0D,0xDF,0x84,0x2E,0x15,0xE3,0x08,0xD7,0x44,0x10,0x41,0xCE,0x93,0xF6,0x59,0x71,0xD2,0xF7,0x1C,0x4A,0x44,0x2D,0xA9,0x44,0x98,0x3A,0x00,0x71,0xCC,0x2A,0x35,0xC1,0x81,0xCF,0x44,0xF7,0x6A,0x0E,0xE4,0xF2,0xFC,0xD6,0x0B,0xA8,0x95,0x7B,0x86,0xB5,0xF8,0x33,0xE9,0xBF,0x6A,0x0E,0xE6,0x53,0x82};
//const unsigned char FCCH80[] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
//const unsigned char SCH40[] = {0x0a,0x3f,0x46,0xb4,0x00};


#define get_ack_l234( tm_ptr ) {\
    Base_tm *ackl234new = new Short_tm;\
    ackl234new->next_TM = NULL;\
    tm_ptr = ackl234new;\
    /*return telemetry pointer here*/\
    ackl234new->TM_string[0] = TMID_ACK_L234 << 4;\
    ackl234new->TM_string[1] = GETpacket_seq_count(current_obsrs_tc);\
    ackl234new->TM_string[2] = ack_code;         /* Ack code ....to be chnaged accordind to situation */\
    for(int i = 3; i < 11; ++i){\
        ackl234new->TM_string[i] = 0x00;\
    }\
    uint16_t crc = crc16_gen(ackl234new->TM_string, TM_SHORT_SIZE-2);\
    ackl234new->TM_string[11] = (crc & 0xFF00) >> 8;\
    ackl234new->TM_string[12] = crc & 0x00FF;\
}

void restart_adf(){
    /*go to phy off and and py on then phy TX again    */
    gCS_ADF = 0;
    spi.write(0xB1);/*phy_on */
    gCS_ADF = 1;
    gCS_ADF = 0;
    spi.write(0xB0);/*phy_off */
    gCS_ADF = 1;
    gCS_ADF = 0;
    spi.write(0xB1);/*phy_on */
    gCS_ADF = 1;
    gCS_ADF = 0;
    spi.write(0xB5);/*start transmission*/
    gCS_ADF = 1;
    }
    
int diff_prev;
void differential_encode(unsigned char* ptr, int length){
        for(int i=0; i<length;i++){
            unsigned char s = ptr[i] , t;
            t = s ^ (s >> 1);
            (diff_prev == 0) ? t=t^0x00 : t=t^0x80 ;
            diff_prev = int(s & 0x01);
            ptr[i] = t;
        }
}

#define check_PA_temp {\
/* pending temperature check function*/\
/*   return 0 or 1*/\
    PA_HOT=0;\
}


#define flags_init {\
 send_EoS_and_stop = false; \
 adf_limit = false;\
 stop = false;\
 PA_HOT=0;\
 short_TC;\
 valid_SID = true;\
 enable_call_sign = true;\
 enable_new_segment=true;\
 enable_S_frame = true;\
 enable_read_block = false;\
 enable_T_frame = false;\
 enable_Ack_andcallsign = false;\
 enable_ackandcallsign = false;\
 new_session =true;\
 enable_EoS=false;\
 create_Ack_andcallsign = true;\
 Ack_andcallsign_over = false;\
 repeat_last_2T_frames = false;\
 last_block = false;\
/* last_buffer = false;*/\
 new_OBSRS_TC = true;\
 enable_SCH = true;\
 enable_FCCH = false;\
 enable_DS = false;\
 half_buffer = 0;\
 read_success = false;\
 counter_buffer_112=0;\
 counter_EoS=0;\
 T_frames_sent=0;\
 counter_interleavedata=0;\
 counter_buffer_512=0;\
 ack_code = 0xA0;\
 segments_sent = 0;\
 counter_SCH40 = 0;\
 counter_FCCH80 = 0;\
 counter_S_frame = 0;\
 T_frame_Ack_andcallsign_sent = 0;\
 T_frame_in_Ackandcallsign ;\
 block_counter = 0;\
 no_of_frames =0;\
}

#define send_Ack_andcallsign {\
    if(T_frames_sent < T_frames_in_segment){\
        if (enable_SCH)\
        {\
            buffer_112[counter_buffer_112] = SCH40[counter_SCH40++];\
            if (counter_SCH40 == 5)\
            {   \
                counter_SCH40 = 0;\
                enable_SCH = false;\
                enable_DS = true;\
            }\
        }\
        else if (enable_DS)\
        {\
            buffer_112[counter_buffer_112] = interleave_data[half_buffer][counter_interleavedata++];\
            if (counter_interleavedata == 144)\
            {   \
                /*gPC.printf("Ads sent  %d\r\n",half_buffer);*/\
                enable_DS = false;\
                enable_FCCH = true;\
                counter_interleavedata = 0;\
            }\
        }\
        else if (enable_FCCH)\
        {\
            buffer_112[counter_buffer_112] = FCCH80[counter_FCCH80++];\
            if (counter_FCCH80 == 10)\
            {\
                /*gPC.printf("Afcch80 sent\r\n");*/\
                enable_FCCH = false;\
                counter_FCCH80 = 0;\
                enable_SCH = true;\
                if(half_buffer == 0){\
                    half_buffer = 1;\
                }\
                else{\
                    half_buffer =0;\
                    TM_sent=true;\
                }\
            }\
        }\
        if(TM_sent){\
            TM_sent =false;\
            T_frames_sent = T_frames_sent +2;\
            if(repeat_last_2T_frames){\
                enable_SCH = true;\
                /*cout<<"T_frames_sent = "<<T_frames_sent<<ENDL;*/\
            }\
            else{\
                /*gPC.printf("Ackandcallsign sent");*/\
                /*cout<<"T_frames_sent = "<<T_frames_sent<<ENDL;*/\
                T_frame_Ack_andcallsign_sent = T_frame_Ack_andcallsign_sent + 2;\
                if(T_frame_Ack_andcallsign_sent == T_frame_in_Ackandcallsign ){\
                    repeat_last_2T_frames = true;\
                    for(int i =0; i<144;i++)\
                    {interleave_data[0][i] = 0;interleave_data[1][i] = 0; }\
                }\
                else{\
                    gPC.printf("error in send ack\r\n");\
                }\
            }\
            if(T_frames_sent == T_frames_in_segment){\
                if(T_frame_Ack_andcallsign_sent < T_frame_in_Ackandcallsign){\
                        gPC.printf("error in tframes sent = in seg");\
                }\
                else{\
                    send_EoS_and_stop = true; \
                }\
            }\
        }\
    }\
    else if(send_EoS_and_stop){\
        buffer_112[counter_buffer_112] = EoS[counter_EoS++];\
       counter_EoS=120;\
        if(counter_EoS == 120){\
            /*gPC.printf("A eos sent\r\n");*/\
            /*cout<<"EoS sent"<<ENDL;*/\
            counter_EoS = 0;\
            enable_ackandcallsign = false;\
            stop =true;\
            last_buffer = true;\
            send_EoS_and_stop = false;\
        }\
    }\
    else if(adf_limit){\
        buffer_112[counter_buffer_112] = EoS[counter_EoS++];\
       counter_EoS=120;\
        if(counter_EoS == 120){\
            counter_EoS = 0;\
            /*gPC.printf("EoS sent");*/\
            restart_adf_flag = true;\
            enable_new_segment = true;\
            /*cout<<"new session"<<ENDL;*/\
            /*cout<<"new segment"<<ENDL;*/\
            T_frames_sent = 0;\
            segments_sent = 0; \
            adf_limit = false;\
        }\
    }\
    else{\
        gPC.printf("error in send_Ack_andcallsign()");\
    }\
}
#define send_S_frame {\
        buffer_112[counter_buffer_112] = S_frame[counter_S_frame++];\
        if(counter_S_frame == 48){\
               enable_new_segment=false;\
               counter_S_frame = 0;\
               /*gPC.printf("S_frame_sent\r\n");*/\
               if(new_OBSRS_TC){\
                    enable_call_sign = true;\
                    new_OBSRS_TC = false;\                   
                    get_call_sign(callsign);\
                    snd_tm.head_pointer_sdcard(callsign);\
                    int temp = snd_tm.make_shor_tm();\
                    delete callsign;\
                    /*gPC.printf("new tc\r\n");*/\
               }\
               else{\
                   if(!enable_ackandcallsign){\
                   enable_read_block = true;\
                   }\
                }\
        }\
}

#define send_call_sign {\
        if (enable_SCH)\
        {\
            buffer_112[counter_buffer_112] = SCH40[counter_SCH40++];\
            if (counter_SCH40 == 5)\
            {   \
                counter_SCH40 = 0;\
                /*gPC.printf("csch40 sent\r\n");*/\
                enable_SCH = false;\
                enable_DS = true;\
            }\
        }\
        else if (enable_DS)\
        {\
            buffer_112[counter_buffer_112] = interleave_data[half_buffer][counter_interleavedata++];\
            /*gPC.printf("csending ds %d \r\n",counter_interleavedata);*/\
            if (counter_interleavedata == 144)\
            {   \
                enable_DS = false;\
                enable_FCCH = true;\
                counter_interleavedata = 0;\
                /*counter_interleavedata = 0;not required here*/\
                /*gPC.printf("cds sent sent \r\n");*/\
            }\
        }\
        else if (enable_FCCH)\
        {\
            buffer_112[counter_buffer_112] = FCCH80[counter_FCCH80++];\
            if (counter_FCCH80 == 10)\
            {\
                enable_FCCH = false;\
                counter_FCCH80 = 0;\
                /*gPC.printf("cfcch sent\r\n");*/\
                if(half_buffer == 0){\
                    enable_SCH = true;\
                    half_buffer = 1;\
                }\
                else{\
                    half_buffer = 0;\
                    TM_sent=true;\
                }\
            }\
        }\
        if(TM_sent){\
            TM_sent= false;\
            enable_call_sign = false;\   
            new_session =false;\
            /*cout<<"call_sign_sent"<<" ";*/\
            T_frames_sent = T_frames_sent+2;\
            check_PA_temp;\
            /*cout<<"pa_hot = "<<PA_HOT<<ENDL;*/\
            if(PA_HOT){\
                enable_ackandcallsign = true;\
                create_Ack_andcallsign = true;\
                enable_read_block = false;\
            }\
            else{\
                enable_read_block = true;\
                enable_ackandcallsign = false;\
            }\
        }\
}

void send_tm_from_SD_card_fun(unsigned char * buffer_112,bool & last_buffer){
/*    gPC.printf("\n\rsend tm sd called\r\n");*/
    for(counter_buffer_112=0;counter_buffer_112<112;counter_buffer_112++){
        if(restart_adf_flag)
            buffer_112[counter_buffer_112] = 0;
        else if(enable_new_segment){                     // starting new segment
            send_S_frame;
            T_frames_sent=0;
        }
        else if(enable_call_sign){                   // sending call sign
            send_call_sign ;
        }
        else if(enable_T_frame){
            if(read_success == 0){
                if(T_frames_sent < T_frames_in_segment){
                    if (enable_SCH)
                    {
                        buffer_112[counter_buffer_112] = SCH40[counter_SCH40++];
                        if (counter_SCH40 == 5)
                        {   
/*                            gPC.printf("tsch40 sent\r\n");*/
                            counter_SCH40 = 0;
                            enable_SCH = false;
                            enable_DS = true;
                        }
                    }
                    else if (enable_DS)
                    {
                        buffer_112[counter_buffer_112] = buffer_512[counter_buffer_512++];
                        if ((counter_buffer_512 == 288) || (counter_buffer_512 == 144))
                        {   
/*                            gPC.printf("tds sent\r\n");*/
//                            counter_buffer_512 = 0;
                            enable_DS = false;
                            enable_FCCH = true;
                        }
                    }
                    else if (enable_FCCH)
                    {
                        buffer_112[counter_buffer_112] = FCCH80[counter_FCCH80++];
                        if (counter_FCCH80 == 10)
                        {
/*                            gPC.printf("tfcch80 sent\r\n");*/
                            enable_FCCH = false;
                            if(counter_buffer_512 == 144){
                                enable_SCH = true;
                                counter_FCCH80 = 0;
                            }
                            else{
                                    
                            }
                        }
                    }
                    if((counter_FCCH80 == 10)&&(counter_buffer_512 == 288)){
                        counter_FCCH80 = 0;
                        counter_buffer_512 = 0;
                        T_frames_sent = T_frames_sent+2;
//                        cout<<"T_frames_sent "<<T_frames_sent<<ENDL;
                        if(last_block){
//                            cout<<"last block"<<endl<<"\r";
/*                            gPC.printf("last block\r\n");*/
                            enable_read_block = false;
                            enable_T_frame = false;
                            enable_ackandcallsign = true;
                            /*putting execution status */
                            uint8_t temp2 = TC_STATE_SUCCESSFULLY_EXECUTED;
                            PUTexec_status(current_obsrs_tc, temp2);
                            create_Ack_andcallsign = true;
                            if(T_frames_sent == T_frames_in_segment){
                                if(segments_sent + 1>= max_segments){
                                    adf_limit = true;
                                    segments_sent = 0;
//                                    gPC.printf("adf limit reached here");
                                }
                                else{
                                    enable_new_segment = true;
//                                    cout<<"new segment"<<ENDL;
                                }
                            }
                            continue;
                        }
                        else{
                            check_PA_temp;
//                            cout<<"pa_hot = "<<PA_HOT<<" ";
                            if(PA_HOT){
                                enable_T_frame = false;
                                enable_read_block = false;
                                enable_ackandcallsign = true;
                                create_Ack_andcallsign = true;
                             }
                             else{
                                 enable_read_block = true;
                             }
                        }
                        if(T_frames_sent == T_frames_in_segment){
                            enable_read_block = false;
                            enable_T_frame = false;
                            if((segments_sent + 1) >= max_segments){
                                adf_limit = true;
                                segments_sent++;
//                                gPC.printf("segments_sent = "<<segments_sent<<ENDL;
//                                gPC.printf("in for adf lim reached");
                            }
                            else{
                                enable_new_segment = true;
//                                gPC.printf("data in next segment");
                                segments_sent++;
//                                cout<<"segments_sent = "<<segments_sent<<ENDL;
                            }
                            continue;
                        }
                        else if(T_frames_sent > T_frames_in_segment){
                            gPC.printf("error in enable T_frame");
                        }
                    }
                }
                else if(T_frames_sent > T_frames_in_segment){
                    gPC.printf("error in if(read_success)");        
                }
            }
            else{
                gPC.printf("error in enable T_frame");
            }
        }
        else if(adf_limit){
            buffer_112[counter_buffer_112] = EoS[counter_EoS++];
            counter_EoS=120;\
            if(counter_EoS == 120){
//                cout<<"EoS sent"<<ENDL;
                restart_adf();
                enable_new_segment = true;
                counter_EoS = 0;
//                cout<<"new session"<<ENDL;
//                cout<<"new segment"<<ENDL;
                T_frames_sent = 0;
                segments_sent = 0; 
                adf_limit = false;
            }
        }
        else if(enable_ackandcallsign){
            if(create_Ack_andcallsign){
                /*gPC.printf("cr ack\r\n")*/;
                enable_SCH = true;
               
                if( (GETexec_status(current_obsrs_tc) == TC_STATE_EXECUTION_FAILED) && (GETabort_on_nack(current_obsrs_tc) == 1) ){
                                gMASTER_STATE = TCL_STATE_ABORTED;
                }
                else if( GETpacket_seq_count(current_obsrs_tc) == (gTOTAL_VALID_TC-1) ){
                    gMASTER_STATE = TCL_STATE_COMPLETED;
                }
                create_Ack_andcallsign = false;
                Base_tm *ack_and_callsign = NULL;
                Base_tm *ack_head = NULL;
//                get_call_sign(ack_and_callsign);
                get_ack_l234(ack_and_callsign);
                ack_head = ack_and_callsign;
                get_ack_l1(ack_and_callsign->next_TM); 
                while(ack_and_callsign->next_TM != NULL){
                    ack_and_callsign = ack_and_callsign->next_TM;
                }
                get_call_sign(ack_and_callsign->next_TM);
                snd_tm.head_pointer_sdcard(ack_head);
                T_frame_in_Ackandcallsign = (2*snd_tm.make_shor_tm());
/*                gPC.printf(" T_frame_in_Ackandcallsign = %d\r\n",T_frame_in_Ackandcallsign);*/
                Base_tm *ack_l234 = ack_and_callsign->next_TM;
                
                ack_and_callsign = ack_head->next_TM;
                
                if( GETshort_or_long_tm(ack_l234) == SHORT_TM_CODE ){
                    for(int i = 0 ; i < TM_SHORT_SIZE ; ++i){
                        gLAST_TM[i] = ack_l234->TM_string[i];
                        gLAST_TM_SHORT_OR_LONG = SHORT_TM_CODE;
                    }
                }
                else{
                    for( int i = 0 ; i < TM_LONG_SIZE ; ++i ){
                        gLAST_TM[i] = ack_l234->TM_string[i];
                        gLAST_TM_SHORT_OR_LONG = LONG_TM_CODE;
                    }
                }
                
                /*gPC.printf("ex cr ack\r\n");*/
            }    
            send_Ack_andcallsign;
            if(last_buffer){
                /*gPC.printf("last buffer"); */
 //               delete ack_head;
//                while(ack_and_callsign != NULL){
//                Base_tm *temp = ack_and_callsign->next_TM;
//                delete ack_and_callsign;
//                ack_and_callsign = temp;
            }
        }
        else if(last_buffer){
            /*gPC.printf("last buffer2");*/
            buffer_112[counter_buffer_112] = 0;
//            delete ack_head;
//            while(ack_and_callsign != NULL){
//            Base_tm *temp = ack_and_callsign->next_TM;
//            delete ack_and_callsign;
//            ack_and_callsign = temp;
//            }
        }
        else if(enable_EoS){
//            send_EoS();
            /*gPC.printf("eos2");*/
            buffer_112[counter_buffer_112] = EoS[counter_EoS++];
            counter_EoS=120;\
            if(counter_EoS == 120){
//                cout<<"segments_sent = "<<segments_sent<<ENDL;
//                cout<<"EoS sent"<<ENDL;
                counter_EoS = 0;
                enable_EoS=false;
                enable_new_segment = true;
                break;
            }    
            else{
                gPC.printf("Error in enable EoS");
                }
        }
        else{
            gPC.printf("error in for loop");    
        }
        if(enable_read_block && (!last_block)){
               if(short_TC){
                   /*cout<<"reading"<<int(FSC)<<" "<<int(SID)<<ENDL;*/
//                        for(int i=0;i<512;i++){
//                        printf("0x%02X,",write_buffer[i]);
//                        }
                   //int write_success = SD_WRITE(write_buffer,FSC + block_counter,SID);
//                   wait_ms(8);
                    //gPC.printf("Reached here hey hey\n");
                   ack_code = SD_READ(buffer_512, FSC + block_counter,SID);
                    //ack_code = 0x02;
               }
               else{
                  // gPC.printf("Reached here hey hey\n");
                   ack_code = SD_READ(buffer_512, list_of_FSC[block_counter],SID);
                   }
               block_counter++;
               if(block_counter == no_of_frames){
                       last_block=true;
               }
               enable_read_block = false;
               if(ack_code == 0xA0){
                  /* gPC.puts("read one block successfully");*/
                   enable_T_frame = true;
                   enable_SCH = true;
                }
                else if(ack_code == 0x88 || ack_code == 0x89){

                    gPC.printf("Hardware failure");
                    enable_T_frame = false;
                }
                else if(ack_code == 0x02){
                    gPC.printf("Invalid SID");
                    enable_T_frame = false;
                }
                else if(ack_code == 0x86){
                    /*gPC.printf("FSC outof bounds");*/
                    enable_T_frame = false;
                }
                else{
                    gPC.printf("error Invalid ack code");
                    enable_T_frame = false;
                    stop = true;
                }
        }
        if((PA_HOT || (gFLAGS & COM_SESSION_TIMEOUT_FLAG) ||(ack_code != 0xA0))&&(!enable_ackandcallsign)&&(!last_buffer)){
            /*gPC.printf("last condition");*/
            uint8_t temp2 = TC_STATE_EXECUTION_FAILED;
            PUTexec_status(current_obsrs_tc, temp2);
            enable_ackandcallsign = true;
            create_Ack_andcallsign = true;
            enable_T_frame = false;
        }
    }
//    for(int i=0;i<112;i++){
//        printf("0x%02X,",buffer_112[i]);
//    }
    differential_encode(buffer_112, 112);
    if(last_buffer ==true){
    diff_prev=0;
    }
}

void execute_OBSRS_TC(Base_tc *tcp){
    current_obsrs_tc = tcp;
    flags_init;
    sent_tmfrom_SDcard = true;
    diff_prev = 0;
    if( GETshort_or_long_tc(tcp) == SHORT_TC_CODE ){
        short_TC = true;
        gPC.printf("it is short TC\r\n");
    }
    else{
        gPC.printf("it is long TC\r\n");
        short_TC = false;    
    }
    /*  reading SID from TC  */
    SID = (tcp->TC_string[2]) & 0x0f;
    /*  reading FSC and no. of frames from TC  */
    if(short_TC){
    FSC  = tcp->TC_string[3] << 24;
    FSC += tcp->TC_string[4] << 16;
    FSC += tcp->TC_string[5] << 8;
    FSC += tcp->TC_string[6];
    no_of_frames = ((uint16_t)(tcp->TC_string[7]) << 8);
    no_of_frames |= (uint16_t)tcp->TC_string[8];
    }
    else{
        no_of_frames = tcp->TC_string[3];
        for(int i=0 ;i<no_of_frames ; i++){
            list_of_FSC[i] = tcp->TC_string[4+i];
        }
    }
    
    gPC.printf("sid = %u \r\n",SID);
    gPC.printf("FSC = %u\r\n",FSC);
    gPC.printf("no_of_frames = %u\r\n",no_of_frames);
//    gPC.puts("exit_sdcard");
    
//    SID = 0x1;
//    FSC = 10;
//    no_of_frames = 2;
//    cout<<"max_segments = "<<max_segments<<ENDL;
    //while(0){
//    while(!stop){
//      //  send_call_sign();
//        if(short_TC){
//            send_tm_from_SD_card();
//        }
//        else{
//            send_tm_from_SD_card();
//        }
//    }
}

#endif