#ifndef SPARKFUNSERIALGRAPHICLCD_H
#define SPARKFUNSERIALGRAPHICLCD_H

#include "mbed.h"
#include "MODSERIAL.h"

class SparkFunSerialGraphicLCD {
public:
    SparkFunSerialGraphicLCD(PinName tx, PinName rx);

    /* 0x00 */  void clear();
    /* 0x01 */  void setDebug(unsigned char level);
    /* 0x02 */  void setBacklight(unsigned char intensity);
    /* 0x03 */  void drawCircle(unsigned char x, unsigned char y, unsigned char radius, bool set);
    /* 0x04 */  void setAutoCRLF(bool enable);
    /* 0x05 */  void eraseBlock(unsigned char x0, unsigned char y0, unsigned char x1, unsigned char y1);
    /* 0x06 */  void reset();
    /* 0x07 */  void setBaud(unsigned char baud);
    /* 0x08 */  void setFont(unsigned char font);
    /* 0x0A */  void setFontMode(unsigned char mode);
    /* 0x0B */  void drawSprite(unsigned char x, unsigned char y, unsigned char sprite, unsigned char mode);
    /* 0x0C */  void drawLine(unsigned char x0, unsigned char y0, unsigned char x1, unsigned char y1, bool set);
    /* 0x0D */    void uploadSprite(unsigned char sprite, unsigned char width, unsigned char height, unsigned char* data);
    /* 0x0F */  void drawBox(unsigned char x0, unsigned char y0, unsigned char x1, unsigned char y1, bool set);
    /* 0x10 */  void setPixel(unsigned char x, unsigned char y, bool set);
    /* 0x12 */  void drawFilledBox(unsigned char x0, unsigned char y0, unsigned char x1, unsigned char y1, unsigned char fill);
    /* 0x14 */  void setReverse(bool enable);
    /* 0x15 */  /*void setSplash();*/
    /* 0x16 */  void bitblt(unsigned char x, unsigned char y, unsigned char mode, unsigned char w, unsigned char h, unsigned char* data);
    /* 0x18 */  void setCursorX(unsigned char x);
    /* 0x19 */  void setCursorY(unsigned char y);
    
    void printf(const char *msg, ...);
    
protected:
    MODSERIAL MySerial;
};

#endif