#include "stdarg.h"
#include "mbed.h"
#include "SparkFunSerialGraphicLCD.h"


SparkFunSerialGraphicLCD::SparkFunSerialGraphicLCD(PinName tx, PinName rx = NC) : MySerial(tx, rx) {
    MySerial.baud(9600);
    clear();
    setBacklight(100);
    setFont(0);
    setAutoCRLF(false);
    setReverse(false);
}

void SparkFunSerialGraphicLCD::clear() {
    MySerial.putc(0x7C);
    MySerial.putc(0x00);
}

void SparkFunSerialGraphicLCD::setDebug(unsigned char level) {
    MySerial.putc(0x7C);
    MySerial.putc(0x01);
    MySerial.putc(level);
}

void SparkFunSerialGraphicLCD::setBacklight(unsigned char intensity) {
    MySerial.putc(0x7C);
    MySerial.putc(0x02);
    MySerial.putc(intensity);
} 

void SparkFunSerialGraphicLCD::drawCircle(unsigned char x, unsigned char y, unsigned char radius, bool set) {
    MySerial.putc(0x7C);
    MySerial.putc(0x03);
    MySerial.putc(x);
    MySerial.putc(y);
    MySerial.putc(radius);
    MySerial.putc(set);
}

void SparkFunSerialGraphicLCD::setAutoCRLF(bool enable) {
    MySerial.putc(0x7C);
    MySerial.putc(0x04);
    MySerial.putc(enable);
}

void SparkFunSerialGraphicLCD::eraseBlock(unsigned char x0, unsigned char y0, unsigned char x1, unsigned char y1) {
    MySerial.putc(0x7C);
    MySerial.putc(0x05);
    MySerial.putc(x0);
    MySerial.putc(y0);
    MySerial.putc(x1);
    MySerial.putc(y1);
}

void SparkFunSerialGraphicLCD::reset() {
    MySerial.putc(0x7C);
    MySerial.putc(0x06);
}

void SparkFunSerialGraphicLCD::setBaud(unsigned char baud) {
    if(baud < 1) baud = 1;
    else if(baud > 6) baud = 6;
    
    MySerial.putc(0x7C);
    MySerial.putc(0x07);
    MySerial.putc(baud);
    switch(baud) {
    case 1:
        MySerial.baud(4800);
        break;
    case 2:
        MySerial.baud(9600);
        break;
    case 3:
        MySerial.baud(19200);
        break;
    case 4:
        MySerial.baud(38400);
        break;
    case 5:
        MySerial.baud(57600);
        break;
    case 6:
        MySerial.baud(115200);
        break;
    }        
}

void SparkFunSerialGraphicLCD::setFont(unsigned char font) {
    MySerial.putc(0x7C);
    MySerial.putc(0x08);
    MySerial.putc(font);
}

void SparkFunSerialGraphicLCD::setFontMode(unsigned char mode) {
    MySerial.putc(0x7C);
    MySerial.putc(0x0A);
    MySerial.putc(mode);
}

void SparkFunSerialGraphicLCD::drawSprite(unsigned char x, unsigned char y, unsigned char sprite, unsigned char mode) {
    MySerial.putc(0x7C);
    MySerial.putc(0x0B);
    MySerial.putc(x);
    MySerial.putc(y);
    MySerial.putc(sprite);
    MySerial.putc(mode);
}

void SparkFunSerialGraphicLCD::drawLine(unsigned char x0, unsigned char y0, unsigned char x1, unsigned char y1, bool set) {
    MySerial.putc(0x7C);
    MySerial.putc(0x0C);
    MySerial.putc(x0);
    MySerial.putc(y0);
    MySerial.putc(x1);
    MySerial.putc(y1);
    MySerial.putc(set);
}

void SparkFunSerialGraphicLCD::uploadSprite(unsigned char sprite, unsigned char width, unsigned char height, unsigned char* data) {
    error("method not implemented");
    MySerial.putc(0x7C);
    MySerial.putc(0x0D);
    MySerial.putc(sprite);
    MySerial.putc(width);
    MySerial.putc(height);
}

void SparkFunSerialGraphicLCD::drawBox(unsigned char x0, unsigned char y0, unsigned char x1, unsigned char y1, bool set) {
    MySerial.putc(0x7C);
    MySerial.putc(0x0F);
    MySerial.putc(x0);
    MySerial.putc(y0);
    MySerial.putc(x1);
    MySerial.putc(y1);
    MySerial.putc(set);
}

void SparkFunSerialGraphicLCD::setPixel(unsigned char x, unsigned char y, bool set) {
    MySerial.putc(0x7C);
    MySerial.putc(0x10);
    MySerial.putc(x);
    MySerial.putc(y);
    MySerial.putc(set);
}
void SparkFunSerialGraphicLCD::drawFilledBox(unsigned char x0, unsigned char y0, unsigned char x1, unsigned char y1, unsigned char fill) {
    MySerial.putc(0x7C);
    MySerial.putc(0x12);
    MySerial.putc(x0);
    MySerial.putc(y0);
    MySerial.putc(x1);
    MySerial.putc(y1);
    MySerial.putc(fill);
}


void SparkFunSerialGraphicLCD::setReverse(bool enable) {
    MySerial.putc(0x7C);
    MySerial.putc(0x14);
    MySerial.putc(enable);
}

/*void SparkFunSerialGraphicLCD::setSplash(bool enable) {
    MySerial.putc(0x7C);
    MySerial.putc(0x15);
    MySerial.putc(enable);
}*/

void SparkFunSerialGraphicLCD::bitblt(unsigned char x, unsigned char y, unsigned char mode, unsigned char w, unsigned char h, unsigned char* data) {
    error("method not implemented");
    MySerial.putc(0x7C);
    MySerial.putc(0x0D);
    MySerial.putc(x);
    MySerial.putc(y);
    MySerial.putc(mode);
    MySerial.putc(w);
    MySerial.putc(h);
}

void SparkFunSerialGraphicLCD::setCursorX(unsigned char x) {
    MySerial.putc(0x7C);
    MySerial.putc(0x18);
    MySerial.putc(x);
}

void SparkFunSerialGraphicLCD::setCursorY(unsigned char y) {
    MySerial.putc(0x7C);
    MySerial.putc(0x19);
    MySerial.putc(y);
}



void SparkFunSerialGraphicLCD::printf(const char *msg, ...) {
    va_list args;
    va_start(args, msg);    
    MySerial.printf(msg, va_arg(args, char*));
    va_end(args);
    wait_ms(100);
}
