
#include "mbed.h"
#include "DS1721.h"

#if defined(TARGET_KL25Z)
    #define I2C_SDA     D7    // D7
    #define I2C_SCL     D6    // D6
    //#define I2C_SDA     D14    // D14
    //#define I2C_SCL     D15    // D15
#elif defined(TARGET_K64F)
    #define I2C_SDA     PTE25   // D14
    #define I2C_SCL     PTE24   // D15
#endif

Serial pc(USBTX, USBRX);
  
int main(void) 
{
    float cTemp;
    
    pc.baud(115200);    
    pc.printf("DS1721 application started.\r\n");
    
    I2C m_i2c(I2C_SDA, I2C_SCL);
    
    DS1721 thermo(m_i2c, (DS1721_ADDR<<1));
    
    
 
    // initialize the temperature sensor
    thermo.startConversion();
    thermo.setLowSp(25.00);
    thermo.setHighSp(27.25);
    thermo.setPolarity(POLARITY_ACTIVE_HIGH);
  
    while (true) 
    {   
        cTemp = thermo.getTemp();     
        pc.printf("Temp: %.2fC/%.2fF\r\n", cTemp, thermo.temp_CtoF(cTemp));
        wait(2.0);
    }  
 } 