#include "mbed.h"
#include "Motor.h"
#include "Servo.h"

int main()
{

    Motor fan(p25, p27, p28);             //pins that listen for commands for the motor

    DigitalIn SW1(p16);                   //reads inputs of switches
    DigitalIn SW2(p17);
    DigitalIn SW3(p18);
    DigitalIn SW4(p19);
    DigitalIn SW5(p20);

BusOut LEDs(p5, p6, p7, p8, p11);         //sends commands to LED lights

    Servo servo1(p21);                    //assigns name to servo at pin 21
    servo1 = 0;                           //sets servo to 0
    servo1.calibrate(0.0009, 45);         //calibrates servo
    
    Servo servo2(p22);                    //assigns name to servo at pin 22
    servo2 = 0;                           //sets servo to 0
    servo2.calibrate(0.0009, 90);         //calibrates servo

    float i, j;                           //float variables
    int led_value = 1;                    //makes integer variable and assigns it a value of 1
    LEDs.write(led_value);                //assigns LEDs the value of 1

    while(1) {                            //infinate while loop

        int S1 = SW1.read();              //assigns switch values to integer variables
        int S2 = SW2.read();
        int S3 = SW3.read();
        int S4 = SW4.read();
        int S5 = SW5.read();
        

        if (S1 == 0 && S2 == 0 && S3 == 0 && S4 == 0 && S5 == 0) { //No switches on, centered position and no rotation
            servo1 = 0.5;                 //servo is positioned in the middle
            fan.speed(0);                 //fan is not moving
        }
    


        else if (S1 == 1 && S2 ==0 && S3 == 0 && S4 == 0 && S5 == 0) {  //Low speed 
            servo1 = 0.5;                 //servo is in the middle
            fan.speed(0.6);               //fan is on a slow speed
            if (led_value < 16) {         //Light pattern #1
            led_value = led_value * 2;    
            LEDs.write(led_value);
            wait(0.55);
            }
            else {
                led_value = 1;            //Light pattern resets
                LEDs.write(led_value);
                wait(0.55);
            }
            }

        else if (S1 == 1 && S2 == 0 && S3 == 0 && S4 == 1 && S5 == 0) { // Low speed & oscillation 
            for (i = 0; i <= 1; i += 0.005) { 
                fan.speed (0.6);          //fan speed is slow
                servo1 = i;               //servo moves a small amount every .025 seconds
                wait(0.025);
                }
            for (i = 1; i >= 0; i -= 0.005) {
                fan.speed (0.6);          //fan speed is slow
                servo1 = i;               //servo moves back small amount every .025 seconds
                wait(0.025);
                }
                }
        else if (S1 == 1 && S2 == 0 && S3 == 0 && S4 == 0 && S5 == 1) { //Low speed & mist
           for (j = 0; j <= 1; j += 1) {  //pulls the string quickly which squeezes the bottle trigger and creates mist
                servo1 = 0.5;             //servo is in the middle
                fan.speed(0.6);           //fan is at low speed
                servo2 = j;               //other servo pulls trigger on mist bottle
                wait(2);
                }
            for (j = 1; j >= 0; j -= 0.05) {
                servo1 = 0.5;             //servo is in the middle
                fan.speed(0.6);           //fan is at low speed
                servo2 = j;               //other servo slowly releases trigger
                wait(0.25);
                }
            }
        else if (S1 == 0 && S2 == 1 && S3 == 0 && S4 == 0 && S5 == 0) { // Med speed 
            servo1 = 0.5;                 //servo is in the middle
            fan.speed(0.8);               //fan is at medium speed
            
            led_value = 16;               //LED pattern #2 (racetrack)
            LEDs.write(led_value);
            wait(0.125);
            led_value = 8;
            LEDs.write(led_value);
            wait(0.125);
            led_value = 4;
            LEDs.write(led_value);
            wait(0.125);
            led_value = 2;
            LEDs.write(led_value);
            wait(0.125);
            led_value = 1;
            LEDs.write(led_value);
            wait(0.125);

            led_value = 2;
            LEDs.write(led_value);
            wait(0.125);
            led_value = 4;
            LEDs.write(led_value);
            wait(0.125);
            led_value = 8;
            LEDs.write(led_value);
            wait(0.125);
            led_value = 16;
            LEDs.write(led_value);
        }

        else if (S1 == 0 && S2 ==1 && S3 == 0 && S4 == 1 && S5 == 0) { //Med speed & oscillation
            for (i = 0; i <= 1; i += 0.005) { //rotates fan slowly and smoothly
                fan.speed (0.8);          //fan speed is medium
                servo1 = i;               //fan oscillates
                wait(0.025);
            }
            for (i = 1; i >= 0; i -= 0.005) {
                fan.speed (0.8);          //fan speed is medium
                servo1 = i;               //fan oscillates
                wait(0.025);
            }
        }
        
        else if (S1 == 0 && S2 == 1 && S3 == 0 && S4 == 0 && S5 == 1) { //Med speed & mist
            for (j = 0; j <= 1; j += 1) { //pulls the string quickly which squeezes the bottle trigger and creates mist
                servo1 = 0.5;             //does not oscillate
                fan.speed(0.8);           //fan speed is medium
                servo2 = j;               //spays mist
                wait(2);
                }
            for (j = 1; j >= 0; j -= 0.05) { //Releases string slowly
                servo1 = 0.5;             //does not oscillate
                fan.speed(0.8);           //fan speed is medium
                servo2 = j;               //Releases string slowly
                wait(0.25);
                }
            }

        else if (S1 == 0 && S2 == 0 && S3 ==1 && S4 == 0 && S5 == 0) { //Fast speed
            servo1 = 0.5;                 //does not oscillate
            fan.speed(0.99);              //fan speed is high
            
            int power;
            power = rand() % 5; // LED pattern #3 Random LED generator 
            led_value = (pow(2, (float)power));
            LEDs.write(led_value);
            wait(0.05);
        }

        else if (S1 == 0 && S2 == 0 && S3 == 1 && S4 == 1 && S5 == 0) { //Fast speed & oscillation
            for (i = 0; i <= 1; i += 0.005) {
                fan.speed (0.99);         //fan speed is high
                servo1 = i;               //fan oscillates
                wait(0.025);
            }
            for (i = 1; i >= 0; i -= 0.005) {
                fan.speed (0.99);         //fan speed is high
                servo1 = i;               //fan oscillates
                wait(0.025);
            }
        }
        else if (S1 == 0 && S2 == 0 && S3 == 1 && S4 == 0 && S5 == 1) { //fast speed & mist
             for (j = 0; j <= 1; j += 1) { //pulls the string quickly which squeezes the bottle trigger and creates mist
                servo1 = 0.5;             //does not oscillate
                fan.speed(0.99);          //fan speed is high
                servo2 = j;               //spays mist
                wait(2);
                }
            for (j = 1; j >= 0; j -= 0.05) {
                servo1 = 0.5;             //does not oscillate
                fan.speed(0.99);          //fan speed is high
                servo2 = j;               //releases string slowly
                wait(0.25);
                }
            }


    }
}