#include "mbed.h"

DigitalIn sw1(p16);
DigitalIn sw2(p17);
DigitalOut ted[5] = {(p26), (p27), (p28), (p29), (p30)};

int main()
{

    int s1, s2;                               //variables for switches
    int n1, n2;                               //variables for random numbers

    while(1)                                  //while loop

        s1 = sw1.read();                      //reads position of switches and assigns to a variable
        s2 = sw2.read();

    if ((s1 == 0) && (s2 == 0)) {            //switch one is off and switch 2 is off
        ted[0] = 1;                          //all lights are on
        ted[1] = 1;
        ted[2] = 1;
        ted[3] = 1;
        ted[4] = 1;
        wait(.2);                            //wait .2 seconds
        ted[0] = 0;                          //all lights are off
        ted[1] = 0;
        ted[2] = 0;
        ted[3] = 0;
        ted[4] = 0;
        wait(.8);                            //wait .8 seconds
    } else if ((s1 == 1) && (s2 == 0)) {     //switch 1 is on and switch 2 is off
        ted[0] = 1;                          //turn on each light is .4 second intervals 
        wait(.4);
        ted[1] = 1;
        wait(.4);
        ted[2] = 1;
        wait(.4);
        ted[3] = 1;
        wait(.4);
        ted[4] = 1;
        wait(.4);
    //lights will now be turned off
        ted[4] = 0;                          //turn off lights in .4 second intervals
        wait(.4);
        ted[3] = 0;
        wait(.4);
        ted[2] = 0;
        wait(.4);
        ted[1] = 0;
        wait(.4);
        ted[0] = 0;
        wait(.4);
    } else if ((s1 == 0) && (s2 == 1)) {     //switch 1 is off and switch 2 is on
        ted[0] = 1;                          //turn on LED 1
        wait(.125);                          //wait for .125 seconds
        ted[0] = 0;                          //turn off LED 1
        ted[1] = 1;                          //turn on LED 2
        wait(.125);                          //wait for .125 seconds
        ted[1] = 0;                          //turn off LED 2
        ted[2] = 1;                          //turn on LED 3
        wait(.125);                          //wait for .125 seconds
        ted[2] = 0;                          //turn off LED 3
        ted[3] = 1;                          //turn on LED 4
        wait(.125);                          //wait for .125 seconds
        ted[3] = 0;                          //turn off LED 4
        ted[4] = 1;                          //turn on LED 5
        wait(.125);                          //wait for .125 seconds
   //lights will be turned off
        ted[3] = 1;                          //turn on LED 4
        ted[4] = 0;                          //turn off LED 5
        wait(.125);                          //wait for .125 seconds
        ted[2] = 1;                          //turn on LED 3
        ted[3] = 0;                          //turn off LED 4
        wait(.125);                          //wait for .125 seconds
        ted[1] = 1;                          //turn on LED 2
        ted[2] = 0;                          //turn off LED 3
        wait(.125);                          //wait for .125 seconds
        ted[0] = 1;                          //turn on LED 1
        ted[1] = 0;                          //turn off LED 2
    } 
    else if (s1 == 1 && s2 == 1) {         //both switches are on
        n1 = rand()% 5 + 1;                //generate random number and assign to variable
        n2 = rand()% 5 + 1;

        if (n1 != n2) {                    //if the two random numbers are not the same
            ted[n1] = 1;                   //light the LEDs corresponding to the random numbers 
            ted[n2] = 1;                  
            wait(0.1);                     //wait 0.1 seconds
        }
    }
}