//This program moves an LED light right and left with two switches

#include "mbed.h"

DigitalIn sw1(p16);
DigitalIn sw2(p17);
BusOut LED(p26, p27, p28, p29, p30);


int main()
{
    int LED_track = 4;                            //initially light 3rd LED
    LED.write(LED_track);                         //assigning LED light to a variable
    int s1, s2;                                   //switch variables

    while(1) {                                    //while loop
        s1 = sw1.read();                          //reads position of switches and assigns to a variable
        s2 = sw2.read();

        if (s1 == 1 && s2 == 1) {                 //both switches are on
            LED_track = 4;                        //3rd LED initially lit
            LED.write(LED_track);                 //assign LEDs to  variable
        } else if (s1 == 1 && s2 == 0) {          //switch 1 is on and switch 2 is off
            if (LED_track > 1) {                  //the far right light is not lit
                LED_track = LED_track / 2;        //moves light to the right
                LED.write(LED_track);             //reassign new LED variable
                wait(0.5);                        //wait 0.5 seconds
            } else {
                LED_track = 16;                   //after the last light is lit this moves the light to the far left
                LED.write(LED_track);             //reassign new LED variable
                wait(0.5);                        //wait 0.5 seconds
            }
        } else if (s1 == 0 && s2 ==1) {           //switch 1 is off and switch 2 is on
            if (LED_track < 16) {                 //far left light is not lit
                LED_track = LED_track * 2;        //moves light to the right
                LED.write(LED_track);             //reassign new LED variable
                wait(0.5);                        //wait 0.5 seconds
            } else {
                LED_track = 16;                   //moves the light back to the far right
                LED.write(LED_track);             //reassign new LED variable
                wait(0.5);                        //wait 0.5 seconds
            }
        } else if (s1 == 0 && s2 ==0) {           //switch one is off and switch 2 is off
            LED_track = 16;                       //far left LED is lit
            LED.write(LED_track);                 //reassign new LED variable
        }


    }
}