
#include "PinDetect.h"
#include "stdio.h"
#include "mbed.h"
#include "SPI_TFT_ILI9341.h"
#include "string"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"
#include "Touch.h"
// **********************************************************************
#define TOUCH_X_MIN 30
#define TOUCH_X_MAX 230
#define TOUCH_Y_MIN 30
#define TOUCH_Y_MAX 240
SPI_TFT_ILI9341 TFT(p5, p6, p7, p8, p9, p10,"TFT");

PinDetect pb1(p26);
 
int score = 0;
int wallSpeed = 1;
int wall1x1 = 80;
int wall1x2 = 100;
int wall1y1 = 0;
int wall1y2 = 40;
int wall2x1 = 80;
int wall2x2 = 100;
int wall2y1 = 88;
int wall2y2 = 128;
 
int ballxpos = 30;
int ballypos = 64;
int ballrad = 3;
 
int volatile ballVel = 1;
 
enum gameState{
    begin,
    playing,
    over};
    
int volatile state;

TOUCH_DATA Coordenadas;

TouchScreenADS7843 MyTouch(p11,p12,p13,p14,p15); // ADS7843-> SDO,SDI,SCK,CS,IRQ

void vISRTouchIRQ(void){
    UINT_COORDxy Temp;

    MyTouch.vTestTouchPanel(&Coordenadas);
    if((Coordenadas.x>TOUCH_X_MIN && Coordenadas.x<TOUCH_X_MAX) && (Coordenadas.y>TOUCH_Y_MIN && Coordenadas.y<TOUCH_Y_MAX)){
        // Cambio de coordenada y escala:
        Temp=Coordenadas.y;
        Coordenadas.y=((float)((255-TOUCH_X_MIN)-Coordenadas.x)*(160.0/(TOUCH_X_MAX-TOUCH_X_MIN)));
        Coordenadas.x=((float)(Temp-TOUCH_Y_MIN)*(240.0/(TOUCH_Y_MAX-TOUCH_Y_MIN)));

    }
}



void pb1_hit_callback() {
       
       switch (state) {
       case begin:
       state = playing;
       break;
       case playing:
       ballVel = ballVel-10;
       break;
       case over:
       state = begin;
       break;
       }
}    
int main() {
    
    state = begin;
    int ready = 0;
     TFT.claim(stdout);      // send stdout to the TFT display
    //TFT.claim(stderr);      // send stderr to the TFT display
    TFT.set_orientation(2);
    TFT.background(Black);    // set background to black
    TFT.foreground(White);    // set chars to white
    TFT.cls();     
    pb1.mode(PullUp);
    wait(.01);
    pb1.attach_deasserted(&pb1_hit_callback);
    pb1.setSampleFrequency();
    TFT.cls();
    TFT.fillrect(0,0,240,320,Blue);
    TFT.fillcircle(ballxpos, ballypos, ballrad, Red);
    TFT.fillrect(wall1x1, wall1y1, wall1x2, wall1y2, Green);
    TFT.fillrect(wall2x1, wall2y1, wall2x2, wall2y2, Green);
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(14,0);
    TFT.printf("%04d", score);
    
    int go = 1;
    int scoreWrite = 1;
    while(go) {
        
        switch (state) {
        case begin:
        
        TFT.locate(4,2);
        TFT.foreground(White);
        TFT.background(Blue);
       // TFT.text_mode(OPAQUE);
        TFT.set_font((unsigned char*) Arial12x12);
        TFT.printf("Flappy mbed");
        
        TFT.locate(1,30);
        TFT.printf("Press PB to Start");
        ready = 0;
        
        
        break;
        
        case playing:
        wait(0.05);
        if (!ready)
        {
            TFT.cls();
            
            wall1x1 = 80;
            wall1x2 = 100;
            wall1y1 = 0;
            wall1y2 = 40;
            wall2x1 = 80;
            wall2x2 = 100;
            wall2y1 = 88;
            wall2y2 = 128;
 
            ballxpos = 30;
            ballypos = 64;
            ballrad = 3;
    
            TFT.fillrect(0,0,128,128,Blue);
            TFT.fillcircle(ballxpos, ballypos, ballrad, Red);
            TFT.fillrect(wall1x1, wall1y1, wall1x2, wall1y2, Green);
            TFT.fillrect(wall2x1, wall2y1, wall2x2, wall2y2, Green);
            ready = 1;
        }
        
        wall1x1--;
        wall2x1--;
        wall1x2--;
        wall2x2--;
        
        if (wall1x2 < -1)
        {
            wall1x2 = 148;
            wall1x1 = 128;
            wall2x2 = 148;
            wall2x1 = 128;
        
            wall1y2 = rand() % (73) + 8;
            wall2y1 = wall1y2 + 48;
            scoreWrite = 1;
        }
        
        if(wall1x2 < 95 && scoreWrite == 1)
        {
            TFT.locate(14,0);
            TFT.printf("%04d", score);
            scoreWrite = 0;
        }
        
        
        TFT.fillrect(wall1x1, wall1y1, wall1x2, wall1y2, Green);
        TFT.fillrect(wall2x1, wall2y1, wall2x2, wall2y2, Green);
        TFT.line(wall1x2+1,wall1y1,wall1x2+1,wall1y2+1,Blue); 
        TFT.line(wall1x2+1,wall2y1,wall1x2+1,wall2y2+1,Blue);
        
        if (ballxpos == (wall1x1 + 10))
        {
            score++;
            TFT.locate(14,0);
            TFT.printf("%04d", score);   
        } 
        
        TFT.fillcircle(ballxpos, ballypos, ballrad, Blue);
        if (ballVel < 2)
            ballVel++;
            
        ballypos = ballypos + ballVel;
        TFT.fillcircle(ballxpos, ballypos, ballrad, Red);
        
        if (ballypos - 2 < wall1y2) {
            if (ballxpos+2 > wall1x1 && ballxpos-2 < wall1x2) {
                state = over;
            }
        }
        else if (ballypos + 2 > wall2y1) {
            if (ballxpos+2 > wall2x1 && ballxpos-2 < wall2x2) {
                state = over;    
            }
        }
        
        if (ballypos > 125) {
            state = over;
        }
        
        break;
        
        case over:
        //open wav file
       if (ready)
        {
        //    Thread::wait(300);
          //  fclose(wave_file);
         //   FILE *wave_file2;
          //  wave_file2=fopen("/sd/sfx_hit.wav","r");
    
            //play wav file
        //    waver.play(wave_file2);
    
            //close wav file
          //  fclose(wave_file2);
            
            if (ballypos < 125)
            {
               //wave_file2=fopen("/sd/sfx_die.wav","r");
    
                //play wav file
                //waver.play(wave_file2);
    
                //close wav file
                //fclose(wave_file2);
                
             //   thread2.signal_set(0x1);
                
                for (int i = ballypos; i < 125; i++)
                {
                     wait(0.03);
                     TFT.fillcircle(ballxpos, i, ballrad, Blue);
                     TFT.fillcircle(ballxpos, i+1, ballrad, Red);   
                }    
            }
        
            TFT.locate(5,8);
            TFT.foreground(White);
            TFT.background(Blue);
            //TFT.text_mode(OPAQUE);
            TFT.set_font((unsigned char*) Arial12x12);
            TFT.printf("Game Over");
        
            TFT.locate(14,0);
            TFT.printf("%04d", score);
            ready = 0;
            score = 0;
        }
        break;
        }
    }
}