#ifndef AD7730_H
#define AD7730_H

#include "mbed.h"

class AD7730{

    public:
        AD7730(PinName mosi, PinName miso, PinName sclk, PinName ready, PinName cs);
        ~AD7730(void);
        
        int readRegistry(int registry);
        int writeRegistry(int registry, int value);
        int initialize(void);
        int systemLowCal(double wgt);
        int systemHighCal(double wgt, double fullScale);
        int read();
        int startConversion(bool wait); 
        void setFilter(int SF, bool chop, int filter2);
        void setFilterSF(int SF);
        void setFilterMode(int mode);
        void setFilterChop(int enabled);
        void reset(bool fullReset);
        int adjustDAC(int direction);
        void start(void);
        void stop(void);
        bool isReady(void);
        double getHz(void);

    
    private:
    
        SPI _spi;
        DigitalOut _cs;
        DigitalIn _readyDig;
        DigitalOut _LED3;
        InterruptIn *_interruptReady;
        PinName  _readyPin;
        double _fullScaleWeight;
        double _minWeight;
        double _maxWeight;
        int _readBuffer[100];
        int _bufferCount;
        int _lastValue;
        bool _continous;
        int _frequency;
        Timer _tmr;
        
        //Registry value constants
        static const int STATUS_REG = 0;
        static const int DATA_REG = 1;
        static const int MODE_REG = 2;
        static const int FILTER_REG = 3;
        static const int DAC_REG = 4;
        static const int OFFSET_REG = 5;
        static const int GAIN_REG = 6;
        static const int TEST_REG = 7;
        
        //define empty spi command
        static const int EMPTY_SPI = 0xFF;
        
        //internal registries
        int _mode;
        int _filter;
        int _dac;
        int _offset;
        int _gain;
        
        
        //timing variables
        Timer _exeTmr;
        int _exeTime;
        
        //error variables
        int _exeError;
        
        //private functions
        int internalZeroCal(void);
        int internalFullCal(void); 
        void interruptRead(void);       
        
        
};

#endif
