#include "mbed.h"

AnalogIn vA(PTB2);
AnalogIn iA(PTB3);
AnalogOut dac0out(DAC0_OUT);
Ticker bandera;
void Filtro(void);
void Kalman(void);
static volatile float PC11=1,PC12=0,PC21=0,PC22=1;
static volatile float X1CN=0, X2CN=0;
static volatile float V11=0.000001f, V22=0.000001f, W=1000;


int main(){
 
if(1){
    uint32_t div1=0,div2=0,busClk=0,adcClk=0;
    SystemCoreClockUpdate();
    div1=( (SIM->CLKDIV1) & SIM_CLKDIV1_OUTDIV1_MASK)>>SIM_CLKDIV1_OUTDIV1_SHIFT;
    div1=1+div1;
    div2=1+( (SIM->CLKDIV1) &
    SIM_CLKDIV1_OUTDIV2_MASK)>>SIM_CLKDIV1_OUTDIV2_SHIFT;
    busClk=SystemCoreClock*div1/div2;
    
    ADC0->SC3 &= ~ADC_SC3_AVGE_MASK;//disable averages
    ADC0->CFG1 &= ~ADC_CFG1_ADLPC_MASK;//high-power mode
    ADC0->CFG1 &= ~0x0063 ; //clears ADICLK and ADIV
    ADC0->CFG1 |= ADC_CFG1_ADIV(1); //divide clock 0=/1, 1=/2, 2=/4, 3=/8
    if (((ADC0->CFG1)& 0x03) == 0) adcClk = busClk/(0x01<<(((ADC0->CFG1)&0x60)>>5));
    if (((ADC0->SC3)& 0x04) != 0) adcClk = adcClk/(0x01<<(((ADC0->SC3)&0x03)+2));
} 
 
DAC0->C0 = 0; 
DAC0->C1 = 0; 
DAC0->C0 = DAC_C0_DACEN_MASK | DAC_C0_DACSWTRG_MASK| DAC_C0_DACRFS_MASK;

bandera.attach_us(&Filtro,50);

while (1) { 
        } 
            
}


//FILTRO DE KALMAN LINEAL IMPLEMENTADO

void Filtro(void){
volatile float PP11,PP12,PP21,PP22,K11,K21,D11,D21;
volatile float X1PN1,X2PN1,X1CN1,X2CN1;
volatile float u,y;
volatile uint16_t yout;


u=((float)vA.read_u16())*33/65535;
y=((float)iA.read_u16())*33/65535;

X1PN1=0.003658303f*u+ 0.9948033528f*X1CN-0.000004789773312f*X2CN;
X2PN1=0.001418225189f*u+0.7727265657f*X1CN+0.9999802845f*X2CN;

PP11 =0.9896337108f*PC11-0.00000476488f*PC12- 0.00000476488f*PC21+0.00000000002294192838f*PC22+0.9999999999f*V11;
PP12=0.7687109781f*PC11+0.9947837396f*PC12- 0.00000370118f*PC21-0.00000478967f*PC22;
PP21=0.7687109781f*PC11- 0.00000370118f*PC12 + 0.9947837394f*PC21- 0.00000478967f*PC22;
PP22=0.5971063454f*PC11 + 0.7727113306f*PC12+ 0.7727113306f*PC21+ 0.9999605694f*PC22+ 0.9999999998f*V22;

K11= (PC11-0.000004814794096f*PC12-0.000004814794096f*PC21+0.0000000000231822422f*PC22+1.010474874f*V11)/(PC11-0.000004814794096f*PC12-0.000004814794096f*PC21+0.0000000000231822422f*PC22+1.010474874f*V11+1.010474874f*W);
K21= (0.7767631292f*PC11-0.000003739954531f*PC12+1.005203974f*PC21-0.000004839850163f*PC22)/(PC11-0.000004814794096f*PC12-0.000004814794096f*PC21+0.0000000000231822422f*PC22+1.010474874f*V11+1.010474874f*W);

D11=K11*(y-X1PN1);
D21=K21*(y-X1PN1);

X1CN1=X1PN1+D11;
X2CN1=X2PN1+D21;

PC11=PP11-K11*PP11;
PC12=PP12-K11*PP12;
PC21=PP21-K21*PP11;
PC22=PP22-K21*PP12;

X1CN=X1CN1;
X2CN=X2CN1;

yout=((uint16_t)(X2CN1*65535/3300));

DAC0->DAT[0].DATL = (uint8_t)(((uint16_t)yout>>4) & 0xFF);
DAC0->DAT[0].DATH = (uint8_t)((((uint16_t)yout>>4) >> 8) & 0x0F);

}
