/** Driver BLE para Proyecto - Pulsera Saturometrica.
 *  Util para implementar rapidamente comunicacion simple BLE.
 *
 * Ejemplo:
 * @code
 * #include "mbed.h"
 * #include "BLE_Driver.h"
 * 
 * DigitalOut CONECT_LED(LED2, 1);
 * DigitalOut TEST_LED(LED3, 1);
 * DigitalIn TEST_BUTTON(p17,PullUp);
 * 
 * void callbackBLE(int event) {
 *     switch (event){
 *         case 1:     CONECT_LED = 0; break;
 *         case 2:     CONECT_LED = 1; break;
 *         }
 *    }
 * 
 * void periodicCallback(void){
 *     uint8_t a;
 *     a= getBLE();
 *     if (a=='G')
 *         TEST_LED = !TEST_LED;
 *     }
 * 
 * int main(void){
 *     iniBLE("Sigfried");
 *     while(1){
 *         if (TEST_BUTTON == 0)
 *             putBLE("Hola\n\r");
 *         }
 *     }
 * @endcode
 */
#ifndef MBED_BLE_DRIVER_H
#define MBED_BLE_DRIVER_H

#include <string.h> 
#include "mbed.h"
#include "BLE.h"
#include "UARTService.h"

#define TX_RX_MSG_LENGTH         160

void putBLE(const char*); //Definicion de rutina de escritura.
void iniBLE(const char*); //Definicion de inicialización. Inicaliza el BLE y el advertising.
uint8_t getBLE(void);     //Definicion de rutina de lectura.

void callbackBLE(int);


 
#endif
