#include "BLE_Driver.h"
#include "mbed.h"

/* Instancias de las clases necesarias para el BLE*/
BLEDevice  ble;
UARTService *uart;

/* Implementacion de los callback de la BLE_API.
 * Es importante notar que ambas funciones hacen un llamado a callbackBLE, que es el callback de esta libreria, implementado en el main de la aplicación. */
void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    ble.startAdvertising();
    callbackBLE(1);
}

void connectionCallback(const Gap::ConnectionCallbackParams_t *params)
{
    callbackBLE(2);
}

/* Funciones de lectura y escritura */

void putBLE(const char* data){
    if (uart) uart->write(data, strlen(data));
    }
    
uint8_t getBLE(void){
    return uart->_getc();
    }
    
/* Inicializaciones */
    
void iniBLE(const char* name){
    /* inicializa BLE en modo uart */
    ble.init();
    uart = new UARTService(ble);
    
    /* inicializa los callbacks a utilizar */
    ble.onDisconnection(disconnectionCallback);
    ble.onConnection(connectionCallback);

    /* configuracion del advertising */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                     (const uint8_t *)name, strlen(name));  // sizeof cambiando por strlen al agretar el parametro name.
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                     (const uint8_t *)UARTServiceUUID_reversed, sizeof(UARTServiceUUID_reversed));

    ble.setAdvertisingInterval(1000); /* 100ms; in multiples of 0.625ms. */
    ble.startAdvertising();
    }