#define _COLOR_SENSOR_
#define _GND_SENSOR_
#define _DHT_SENSOR_
#include "DS1820.h"
#include "DHT.h"
#include "glibr.h"



extern float airTemperature;
extern float airHumidity;
extern unsigned short ambientLight, redLight, greenLight, blueLight;
extern double gndTemperature;
extern int gndHumidity;
extern DS1820 gndTemperatureSensor; 
extern AnalogIn gndHumSensor;
#ifdef _DHT_SENSOR_
#endif

#ifdef _COLOR_SENSOR_
extern glibr rgbSensor; // liaison de type I2C avec le module de mesure de lumière

void init_rgbSensor(); // initialise le capteur de lumière
void getLightValues(unsigned short *ambientLight, unsigned short *redLight, unsigned short *greenLight, unsigned short *blueLight); // récupère les données du capteur de lumière
#endif

#ifdef _GND_SENSOR_

#define GND_TMP_SENSOR A0
#define HUM_MAX 24500.0
#define HUM_MIN 20600.0

void init_gndTmp(); //initialise le capteur de température du sol
double getGndTemperature(); // retourne la valeur de la température du sol en °C
int getGndHumidity();
#endif
