#include "Sensor.h"


unsigned short ambientLight = 0, redLight = 0, greenLight = 0, blueLight = 0;
double gndTemperature = 0.0;
int gndHumidity = 0;
float airTemperature = 0.0;
float airHumidity = 0.0;

#ifdef _COLOR_SENSOR_
void init_rgbSensor() {
    rgbSensor.enablePower();
    rgbSensor.enableLightSensor();
    rgbSensor.disableProximitySensor();
    rgbSensor.disableGestureSensor();    
}

void getLightValues(unsigned short *ambientLight, unsigned short *redLight, unsigned short *greenLight, unsigned short *blueLight) {
    rgbSensor.readAmbientLight(ambientLight); 
    rgbSensor.readRedLight(redLight);
    rgbSensor.readGreenLight(greenLight);
    rgbSensor.readBlueLight(blueLight);   
}
#endif


#ifdef _GND_SENSOR_
void init_gndTmp() {
    int i;
    for(i=0; i<5; i++) DS1820::unassignedProbe(GND_TMP_SENSOR);
}



double getGndTemperature(){
    double temperature;
    gndTemperatureSensor.convertTemperature(true, DS1820::all_devices);
    temperature = gndTemperatureSensor.temperature();
    return temperature;
}

int getGndHumidity() {
    return gndHumSensor.read_u16();
}
#endif