#include "ADA326.h"
#include "mbed.h"
#include "arial_font_48_64.h"

#define BLACK 0
#define WHITE 1
#define INVERSE 2

#define SSD1306_LCDHEIGHT 64
#define SSD1306_LCDWIDTH 128


extern Serial pc;

LCDGraphics::LCDGraphics(uint16_t width, uint16_t height, uint8_t page)
{
    // Initialize.
    this->chBuffer = NULL;
    this->sizeFont = 1.0f;
    this->spacing = 0;
    this->width = width;
    this->height = height;
    this->page = page;
    this->com_per_page = height / page;
    this->fontWidth = FONT_WIDTH;
    this->fontHeight = FONT_HEIGHT;
    //Allocate screen bitmap buffer that will eventually be displayed on the screen.
    this->screen = (uint8_t **)malloc(sizeof(uint8_t*) * width + 1);
    for(int x = 0; x < width; x++)
        this->screen[x] = (uint8_t *)malloc(sizeof(uint8_t) * page + 1);
}
// Horizontal spacing between characters
void LCDGraphics::setFontSpacing(int8_t spacing)
{
    if(spacing > FONT_WIDTH || spacing < -FONT_WIDTH) {
        pc.printf("Too much spacing.\r\n");
        return;
    }
    this->spacing = spacing;
}
// Set font size. Parameter taken is 0~100% in float. 
// Maximum size is 48 x 48 (100% = 1.0f) and minimum is 4 x 4 (10% = 0.1f)
void LCDGraphics::setFontSize(float size)
{
 //   int length;
    if(size > 1.0f || size < 0.1f) {
        pc.printf("Font size cannot exceed 100%% or go below 10%%.\r\n");
        return;
    }
    fontWidth = (uint8_t)(FONT_WIDTH * size);
    fontHeight = (uint8_t)(FONT_HEIGHT * size);
    sizeFont = size;
}
// Set a pixel at coordinate (x,y) on the screen.
void LCDGraphics::setPixel(uint16_t x,uint16_t y, uint8_t color)
{
    uint8_t com_pos = y % com_per_page; 
    uint8_t page_pos = y / page;
    if (x > SSD1306_LCDWIDTH || y > SSD1306_LCDHEIGHT)
        return;
    switch(color) {
        case WHITE: 
            this->screen[x][page_pos] |= WHITE << com_pos;
            break;
        case BLACK: 
            this->screen[x][page_pos] &= ~(WHITE << com_pos);
            break;
        case INVERSE: 
            this->screen[x][page_pos] ^= WHITE << com_pos;
            break;
    }
}
#define CH_PIXEL_INDEX(x,y) ((y / 8) * 8 + x)
// Write a character at the coordinate (x0, y0)
void LCDGraphics::write(char c, uint8_t x0, uint8_t y0)
{
    uint32_t finalWidth = 0, finalHeight = 0;
    uint32_t x_ratio, y_ratio;
    uint16_t x2, y2;
    const uint8_t *character = index_of_char(c);
    // Resize according to the defined font size.
    finalWidth = floor(FONT_WIDTH * sizeFont); 
    finalHeight = floor(FONT_HEIGHT * sizeFont);
    x_ratio = ((FONT_WIDTH << 16) / finalWidth ) + 1;
    y_ratio = ((FONT_HEIGHT << 16) / finalHeight ) + 1;
    if(!character) {
        pc.printf("Sorry. Unsupported character.\r\n");
        return;
    }
    
    for(int y = 0; y < finalHeight; y++){    
        for(int x = 0; x < finalWidth; x++){
            x2 = (x * x_ratio) >> 16;
            y2 = (y * y_ratio) >> 16;
            //pc.printf("(%d,%d)=>(%d, %d) : %d  %d\r\n", x,y,x2,y2, ((int)(y2 / 8))*8,y2 % 8);
            setPixel(x0 + x, y0 + y, (character[((int)(y2 / 8))*FONT_WIDTH + x2] >> (y2 % 8))&0x1);
            
        }
    }
}
int iCol = 0, iLine = 0;
void LCDGraphics::print(const char *str, const uint8_t *pchEx, int numEx)
{
    char ch;
    int i = 0, iEx = 0;
    iCol = 0;
    iLine = 0;
    while(str[i] != '\0')
    {
        ch = str[i];
        switch(ch) {
        case '\n' : // New line
            iLine++;
            break;
        case '\r' : // Return cursor to the first colomn.
            iCol = 0;
            break;
        
        case '\*': // Display special character.
            if(iEx < numEx)  {
                ch = pchEx[iEx++];      
            }
        default : 
            // If the mamximum number of characters per line is reached, create a new line.
            if(iCol * (spacing + fontWidth) > SSD1306_LCDWIDTH - fontWidth) {
                iLine++;
                iCol = 0;
            }
            // If the mamximum number of lines is reached, write no more.
            if(iLine * fontHeight > SSD1306_LCDHEIGHT - 1) {
                return;
            }
            // write character and set cursor to the next position.
            write(ch, iCol * (spacing + fontWidth), iLine * fontHeight);
            iCol++;
            break;
        }
        i++;
    }
}
// Read the predefined font bitmaps 
const uint8_t* LCDGraphics::index_of_char(uint8_t c)
{
    if('!' <= c && c <= '~')
    {
        return ascii[c - '!'];
    }
    else if (c == ' ')
    {   
        return ch_space;
    }
    else // special characters
    {        
        switch(c) {
            case A_CIRCONFLEX_MAJ : return ascii_extended[CHAR_A_CHAPEAU_MAJ];
            case A_CIRCONFLEX_MIN : return ascii_extended[CHAR_A_CHAPEAU_MIN];
            case A_GRAVE_MAJ : return ascii_extended[CHAR_A_GRAVE_MAJ];
            case A_GRAVE_MIN : return ascii_extended[CHAR_A_GRAVE_MIN];
            case AE_MAJ : return ascii_extended[CHAR_AE_MAJ];
            case AE_MIN : return ascii_extended[CHAR_AE_MIN];
            case CEDILE_MAJ :return ascii_extended[CHAR_C_EDILE_MAJ];
            case CEDILE_MIN :return ascii_extended[CHAR_C_EDILE_MIN];
            case E_GRAVE_MAJ : return ascii_extended[CHAR_E_GRAVE_MAJ];
            case E_GRAVE_MIN : return ascii_extended[CHAR_E_GRAVE_MIN];
            case E_AIGU_MAJ : return ascii_extended[CHAR_E_AIGU_MAJ];
            case E_AIGU_MIN : return ascii_extended[CHAR_E_AIGU_MIN];
            case E_CIRCONFLEX_MAJ : return ascii_extended[CHAR_E_CHAPEAU_MAJ];
            case E_CIRCONFLEX_MIN : return ascii_extended[CHAR_E_CHAPEAU_MIN];
            case E_TREMA_MAJ : return ascii_extended[CHAR_E_TREMA_MAJ];
            case E_TREMA_MIN : return ascii_extended[CHAR_E_TREMA_MIN];
            case I_CIRCONFLEX_MAJ : return ascii_extended[CHAR_I_CHAPEAU_MAJ];
            case I_CIRCONFLEX_MIN : return ascii_extended[CHAR_I_CHAPEAU_MIN];
            case I_TREMA_MAJ : return ascii_extended[CHAR_I_TREMA_MAJ];
            case I_TREMA_MIN : return ascii_extended[CHAR_I_TREMA_MIN];
            case O_CIRCONFLEX_MAJ : return ascii_extended[CHAR_O_CHAPEAU_MAJ];
            case O_CIRCONFLEX_MIN : return ascii_extended[CHAR_O_CHAPEAU_MIN];
            case O_TREMA_MAJ : return ascii_extended[CHAR_U_TREMA_MAJ];
            case O_TREMA_MIN : return ascii_extended[CHAR_O_TREMA_MIN];
            case U_CIRCONFLEX_MAJ : return ascii_extended[CHAR_U_CHAPEAU_MAJ];
            case U_CIRCONFLEX_MIN :return ascii_extended[CHAR_U_CHAPEAU_MIN];
            case U_GRAVE_MAJ : return ascii_extended[CHAR_U_GRAVE_MAJ];
            case U_GRAVE_MIN : return ascii_extended[CHAR_U_GRAVE_MIN];
            case U_TREMA_MIN : return ascii_extended[CHAR_U_TREMA_MIN];
            case U_TREMA_MAJ : return ascii_extended[CHAR_U_TREMA_MAJ];
            case DEGREE : return ascii_extended[CHAR_DEGREE];
            case EURO : return ascii_extended[CHAR_EURO];
        }
    }
    return NULL;
}