#include "HMI.h"

using namespace FSM_Button;
bool bouncing = false;
bool trigger_standby = false;
bool display_on = false;
volatile bool RE_detected = false;
bool next_screen = false;
bool renew_screen = false;

#define DEBOUNCE_DURATION_MS 200
#define HIGH_LEVEL_DURATION 2

/* 
Rising_edge flag is on ? Idle state => Debounce 
    - Start chronometer
 */
unsigned int FSM_Button::button_idle(void)
{   
    if (!RE_detected)
        return FSM_Button::State_Idle;
    timer.start();
    return FSM_Button::State_Debounce;
}

/*
timer < Wait Duration ? Debounce => Debounce.
    - All incoming button signals are ignored during this time.
timer >= Wait Duration ? Debounce => Pressed
*/
unsigned int FSM_Button::button_debounce(void)
{
    if (timer.read_ms() < DEBOUNCE_DURATION_MS)
        return FSM_Button::State_Debounce;
    return FSM_Button::State_Pressed;
}
/*
button signal on high level ? Pressed => Pressed
    - timer > 2~5 s  ?  Trigger screen standby on.
button signal on low level ? Pressed => Released
    - Change display
*/

unsigned int FSM_Button::button_pressed(void)
{
    if(button) {
        if(timer.read() >= HIGH_LEVEL_DURATION)
            trigger_standby = true;
        return FSM_Button::State_Pressed;    
    }
    //led = 0;
    renew_screen = true;
    next_screen = true;
    return FSM_Button::State_Released;
}

/*
Released => Wait
    - Restart timer.
    - Initialize standby trigger flag.
    - Initialize rising edge detection flag.
*/
unsigned int FSM_Button::button_released(void)
{   
    RE_detected = false;
    trigger_standby = false; 
    timer.reset();
    return FSM_Button::State_Wait;
}
/*

timer < Wait Duration ? Wait => Wait.
    - All incoming button signals are ignored during this time.
timer >= Wait Duration ? Wait => Idle
    - Stop and reset timer.
*/
unsigned int FSM_Button::button_wait(void)
{
    if (timer.read_ms() < DEBOUNCE_DURATION_MS)
        return FSM_Button::State_Wait;
    timer.stop();
    timer.reset();
    return FSM_Button::State_Idle;
}
