#include "LinkedList.h"

class Transition
{
    public:
    Transition(){}
    Transition(int from, int to): _from(from), _to(to) {}
    private:
    int _from;
    int _to;
};
class FSM 
{
    public:
    FSM(size_t num_state);
    ~FSM();
    void setInitialState(unsigned int uid);
    void addState(unsigned int uid,unsigned int (*state)(void));
    void addTransition(int from, int to);
    void execute();
    
    //attributes
    private:    
    
    //attributes
    struct MachineState {
        unsigned int uid;
        unsigned int (*state)(void);
    }MachineState;
    unsigned int _uid_zero;
    unsigned int _cur_state;
    struct MachineState *states; // Arrays that store states;
    LinkedList<node> trans;
    size_t _num_state;
    size_t _index_state;
    
};