#include "ADA326.h"
#include "LCDGraphics.h"
#include "mbed.h"


#define SSD1306_LCDHEIGHT 64
#define SSD1306_LCDWIDTH 128

#define SSD1306_SETCONTRAST 0x81
#define SSD1306_DISPLAYALLON_RESUME 0xA4
#define SSD1306_DISPLAYALLON 0xA5
#define SSD1306_NORMALDISPLAY 0xA6
#define SSD1306_INVERTDISPLAY 0xA7
#define SSD1306_DISPLAYOFF 0xAE
#define SSD1306_DISPLAYON 0xAF

#define SSD1306_SETDISPLAYOFFSET 0xD3
#define SSD1306_SETCOMPINS 0xDA

#define SSD1306_SETVCOMDETECT 0xDB

#define SSD1306_SETDISPLAYCLOCKDIV 0xD5
#define SSD1306_SETPRECHARGE 0xD9

#define SSD1306_SETMULTIPLEX 0xA8

#define SSD1306_SETLOWCOLUMN 0x00
#define SSD1306_SETHIGHCOLUMN 0x10

#define SSD1306_SETSTARTLINE 0x40

#define SSD1306_MEMORYMODE 0x20
#define SSD1306_COLUMNADDR 0x21
#define SSD1306_PAGEADDR   0x22

#define SSD1306_COMSCANINC 0xC0
#define SSD1306_COMSCANDEC 0xC8

#define SSD1306_SEGREMAP 0xA0

#define SSD1306_CHARGEPUMP 0x8D

#define SSD1306_EXTERNALVCC 0x1
#define SSD1306_SWITCHCAPVCC 0x2

// Scrolling #defines
#define SSD1306_ACTIVATE_SCROLL 0x2F
#define SSD1306_DEACTIVATE_SCROLL 0x2E
#define SSD1306_SET_VERTICAL_SCROLL_AREA 0xA3
#define SSD1306_RIGHT_HORIZONTAL_SCROLL 0x26
#define SSD1306_LEFT_HORIZONTAL_SCROLL 0x27
#define SSD1306_VERTICAL_AND_RIGHT_HORIZONTAL_SCROLL 0x29
#define SSD1306_VERTICAL_AND_LEFT_HORIZONTAL_SCROLL 0x2A

#define BLACK 0
#define WHITE 1
#define INVERSE 2


    
extern Serial pc;
DigitalOut reset(D3);

#ifdef _ADA326_VER_I2C_
#define I2C_ADDR (0x3D << 1)
extern I2C i2c;
#endif 
Ada326::Ada326():
LCDGraphics(SSD1306_LCDWIDTH,SSD1306_LCDHEIGHT, MAX_PAGE)
{
    pc.baud(9600);
#ifdef _ADA326_VER_I2C_
    pc.printf("ADA326 : Initialize I2C\r\n");
    pc.printf("ADA326 : %d x %d\r\n", width, height);
    i2c.frequency(400000);
#endif    
}
void Ada326::display_on() 
{
    initialize();
}
void Ada326::display_off()
{
    
#ifdef _ADA326_VER_I2C_
    i2c.start();  
#endif    
    ssd1306_command(SSD1306_DISPLAYOFF);                    // 0xAE
#ifdef _ADA326_VER_I2C_
    i2c.stop(); 
#endif    
}
void Ada326::initialize()
{
    
    // Setup reset pin direction (used by both SPI and I2C)
    reset = 1;
    // VDD (3.3V) goes high at start, lets just chill for a ms
    wait_ms(1);
    // bring reset low
    reset = 0;
    // wait 10ms
    wait_ms(10);
    // bring out of reset
    reset = 1;
    
#ifdef _ADA326_VER_I2C_
    i2c.start();  
#endif    
    ssd1306_command(SSD1306_DISPLAYOFF);                    // 0xAE
    ssd1306_command(SSD1306_SETDISPLAYCLOCKDIV);            // 0xD5
    ssd1306_command(0x80);                                  // the suggested ratio 0x80
    
    ssd1306_command(SSD1306_CHARGEPUMP);                    // 0x8D
    ssd1306_command(0x14);
    ssd1306_command(SSD1306_MEMORYMODE);                    // 0x20
    ssd1306_command(0x00);                                  
    ssd1306_command(SSD1306_COMSCANDEC);                    // Write Pixels Downward.
    ssd1306_command(SSD1306_SEGREMAP|0x1);                  // Write Pixels Rightward.
    
    ssd1306_command(SSD1306_NORMALDISPLAY);
    ssd1306_command(SSD1306_DISPLAYON);//--turn on oled panel 
#ifdef _ADA326_VER_I2C_
    i2c.stop(); 
#endif    
}
// Send command through i2c communication
void Ada326::ssd1306_command(uint8_t cmd)
{
    char data[] = {0x00, cmd};
    i2c.write(I2C_ADDR, data, 2);
    wait_us(1);
}
// Wipe out all pixels (display pitch black)
void Ada326::clear(bool show)
{
    for (uint16_t page = 0; page < MAX_PAGE; page++)
        for (uint16_t seg=0; seg < width; seg++) 
            screen[seg][page] = 0x0;
    if(show)
        display();   
}
// Renew display
void Ada326::display()
{
    
#ifdef _ADA326_VER_I2C_
    i2c.start();  
#endif    
    // Let screen know that the entire display is used. (128x64)
    ssd1306_command(SSD1306_COLUMNADDR);
    ssd1306_command(0);   // Column start address (0 = reset)
    ssd1306_command(SSD1306_LCDWIDTH-1); // Column end address (127 = reset)

    ssd1306_command(SSD1306_PAGEADDR);
    ssd1306_command(0); // Page start address (0 = reset)
    ssd1306_command(7); // Page end address (8th page)

    // Signal to write pixels on the screen.
    i2c.write(I2C_ADDR);
    i2c.write(0x40);
    wait_us(10);
    int error;
    // Write in consecutive manner.
    for (uint16_t page = 0; page < MAX_PAGE; page++) {
        for (uint16_t seg=0; seg < width; seg++) {
#ifdef _ADA326_VER_I2C_
            error =i2c.write(screen[seg][page]);
#elif _ADA326_VER_SPI_
#endif    
        if (error != 1)
            pc.printf("Error occured.\r\n");
        }
    }
#ifdef _ADA326_VER_I2C_
    i2c.stop(); 
#endif    

}
uint16_t Ada326::getWidth()
{
    return SSD1306_LCDWIDTH;
}
uint16_t Ada326::getHeight()
{
    return SSD1306_LCDHEIGHT;
}
// Replicate screen on the pc terminal. (Debugging purpose)
void Ada326::serial_display()
{
      for (uint16_t y = 0; y < height; y++) {
           for (uint16_t x = 0; x < width; x++) {
             pc.printf("%d", (screen[x][y / page] >> y % com_per_page) & 0x1);
        }
        pc.printf("\r\n");
    }
}