
/**
Author : Roqyun KO
Electronics / Computer Science - Embedded System (EISE)
EISE 4 - Industrial Project 1.
Polytech Paris Sorbonne 

Library related to the graphics.
**/

#ifndef _CITRON_MERANGUE_LCDGRAPHICS_H
#define _CITRON_MERANGUE_LCDGRAPHICS_H

#include <stdint.h>


#define A_CIRCONFLEX_MAJ 129
#define A_CIRCONFLEX_MIN 130
#define A_GRAVE_MAJ 131
#define A_GRAVE_MIN 132
#define AE_MAJ 133
#define AE_MIN 134
#define CEDILE_MAJ 135
#define CEDILE_MIN 136
#define E_GRAVE_MAJ 137
#define E_GRAVE_MIN 138
#define E_AIGU_MAJ 139
#define E_AIGU_MIN 140
#define E_CIRCONFLEX_MAJ 141
#define E_CIRCONFLEX_MIN 142
#define E_TREMA_MAJ 143
#define E_TREMA_MIN 144
#define I_CIRCONFLEX_MAJ 145
#define I_CIRCONFLEX_MIN 146
#define I_TREMA_MAJ 147
#define I_TREMA_MIN 148
#define O_CIRCONFLEX_MIN 149
#define O_TREMA_MIN 150
#define U_CIRCONFLEX_MIN 151
#define U_CIRCONFLEX_MAJ 152
#define U_GRAVE_MAJ 153
#define U_GRAVE_MIN 154
#define U_TREMA_MIN 155
#define O_CIRCONFLEX_MAJ 156
#define O_TREMA_MAJ 157
#define U_TREMA_MAJ 158
#define DEGREE 159
#define EURO 160

#define FONT_SIZE_64_48
 
#ifdef FONT_SIZE_64_48
#define FONT_WIDTH 48
#define FONT_HEIGHT 64
#endif

class LCDGraphics
{
    
public:
    LCDGraphics();
    LCDGraphics(uint16_t width, uint16_t height, uint8_t page);
    void setPixel(uint16_t x,uint16_t y, uint8_t color);
    void setFontSize(float size); // parameter size takes in a value between 0.1f ~ 1.0f (10 ~ 100%). 100% font size is 48x48.
    void setFontSpacing(int8_t spacing); // Set horizontal spacing between each character.
    void write(char c, uint8_t x, uint8_t y);
    void print(const char *str, const uint8_t *pchEx = (uint8_t*)0, int numEx = 0);
    //void append(const char *str, uint8_t *pchEx = (uint8_t*)0, int numEx = 0); not supported yet.
private :
    const uint8_t* index_of_char(uint8_t c);
    uint8_t *chBuffer;
    float sizeFont;
    uint8_t fontWidth;
    uint8_t fontHeight;
    int8_t spacing;
protected : 
    uint16_t width;
    uint16_t height;
    uint16_t page;
    uint16_t com_per_page;
    uint8_t **screen;
    
};
#endif