#include "HMI.h"
#include "Sensor.h"
#include "LCDGraphics.h"
using namespace FSM_Display;

#define FIRST_DATA Light_Data
#define LAST_DATA Air_Humidity
Display_Type curScreen;


// Select the next data to display.
Display_Type nextScreen(Display_Type screen)
{
    switch (screen) {
        case Light_Data : 
            screen = Gnd_Temperature;
            break;
        case Gnd_Temperature :
            screen = Gnd_Humidity;
            break;
        case Gnd_Humidity :
            screen = Air_Temperature;
            break;
        case Air_Temperature : 
            screen = Air_Humidity;
            break;
        case Air_Humidity : 
            screen = Light_Data;
            break;
        default :
            break;
    }
    return screen;
}

// Special characters supported by our library.
const uint8_t extended_ch[] = {E_AIGU_MIN, DEGREE}; 
// Print the data on the display.
void showData(Display_Type screen)
{
    char buffer[256];  
    size_t len_extended_ch = 0;
    lcd.clear(false);
    switch (screen) {
        case Light_Data : 
            sprintf(buffer, "ambient:%d\n\rred:%d\n\rgreen:%d\n\rblue:%d\n\r", ambientLight, redLight, greenLight, blueLight);
            len_extended_ch = 0;
            break;
        case Gnd_Temperature :
            sprintf(buffer, "Temp\*rature\r\ndu sol:\n\r%.02f\*C\n\r", gndTemperature); 
            len_extended_ch = 2;
            break;
        case Gnd_Humidity :
            sprintf(buffer, "Humidit\*\r\ndu sol:\r\n%02d %%\n\r", gndHumidity);
            len_extended_ch = 1;
            break;
        case Air_Temperature : 
            sprintf(buffer, "Temp\*rature\r\nambient:\n\r%.02f\*C\n\r", airTemperature); 
            len_extended_ch = 2;
            break;
        case Air_Humidity : 
            sprintf(buffer, "Humidit\*\r\nambient:\r\n%.02f %%\n\r", airHumidity);
            len_extended_ch = 1;
            break;
        default :
            break;
    }
    lcd.print(buffer, extended_ch, len_extended_ch);      
    lcd.display();
}

/*
screen standby trigger flag is on ? idle => standby
screen renewal flag? 
    - display is off ? idle -> activate
    - display is on ? idle -> write
        - next display flag is on ? prepare the next data to write on screen.
        - initialize renewal flag
if not, idle => idle.
*/
unsigned int FSM_Display::display_idle(void) 
{
    if (trigger_standby) 
        return FSM_Display::State_Standby;
    if (renew_screen) {
         if (!display_on)
            return FSM_Display::State_Activate;
            
        if(next_screen) {
            curScreen = nextScreen(curScreen);
            next_screen = false;
        }
        renew_screen = false;
        return FSM_Display::State_Write;
    }
    return FSM_Display::State_Idle;
}
/*
standby => idle
    - turn on standby mode.
    - turn off other screen related flags.
    - turn off the display.
*/
unsigned int FSM_Display::display_standby(void) 
{    

    modeSleep = true;
    display_on = false;
    renew_screen = false;
    next_screen = false;
    lcd.display_off();
    //pc.printf("STANDBY\r\n");
    return FSM_Display::State_Idle;
}

/*
activate => idle
    - turn off standby mode.
    - turn on other screen related flags.
    - turn on the display.
    - prepare to display light measurement data.
*/
unsigned int FSM_Display::display_activate(void) 
{   

    modeSleep = false;
    display_on = true;
    curScreen = LAST_DATA;
    renew_screen = true;
    next_screen = true;
    //pc.printf("Activate\r\n");
    lcd.display_on();
    return FSM_Display::State_Idle;
}

/*
write => idle
    - write data on screen .
*/
unsigned int FSM_Display::display_write(void)
{   
    //pc.printf("WRITE\r\n");
    showData(curScreen);
    return FSM_Display::State_Idle;
}