#include "mbed.h"
#include "ADA326.h"

extern bool modeSleep;

extern volatile bool RE_detected;
extern bool display_on;
extern bool trigger_standby;
extern bool next_screen;
extern bool renew_screen;

extern DigitalOut led;
extern InterruptIn button;
extern Timer timer;
extern Ticker ticker;
extern Serial pc;
extern Ada326 lcd;

namespace FSM_Button {
    // Finite state machine for debouncing button (preventing unstable response)
    enum  {State_Idle = 0, State_Debounce, State_Pressed, State_Released, State_Wait};
    const int NB_BUTTON_STATE = 5;
    unsigned int button_idle(void);
    unsigned int button_debounce(void);
    unsigned int button_pressed(void);
    unsigned int button_released(void);
    unsigned int button_wait(void);
}
namespace FSM_Display {
    // Finite state machine for the change of display (Turn off -> Turn on -> Sensor data -> Turn off).
    enum Display_Type {Light_Data, Gnd_Temperature, Gnd_Humidity, Air_Temperature, Air_Humidity};
    enum {State_Idle = 0, State_Activate,State_Standby, State_Write};
    const int NB_DISPLAY_STATE = 4;
    unsigned int display_standby(void);
    unsigned int display_activate(void);
    unsigned int display_idle(void);
    unsigned int display_write(void);

}


