#include "FSM.h"
#include "HMI.h"
#include "LinkedList.h"

FSM::FSM(size_t num_state) 
{
    _index_state = 0;
    _num_state = num_state;
    states = new struct MachineState[num_state];
    if(states == NULL)
        pc.printf("FSM - assignment failed.\r\n");  
}

FSM::~FSM() 
{
    delete[] states;
}
void FSM::addState(unsigned int uid,unsigned int (*state)(void))
{
    struct MachineState ms;
    ms.uid = uid;
    ms.state = state;
    states[_index_state++] = ms;
}

void FSM::addTransition(int from, int to)
{
    trans.append(new Transition(from, to));
}
void FSM::setInitialState(unsigned int uid)
{
    _uid_zero = uid;
    _cur_state = _uid_zero;
}
void FSM::execute()
{
    unsigned int next_uid = 0;
    next_uid = states[_cur_state].state();
    for (int i = 0; i < _num_state; i++) {
        if(next_uid == states[i].uid) {
            _cur_state = i;
        }
    }
}
        
