#include "mbed.h"
FILE *myLogFile;
Ticker sampleTicker;
AnalogIn sensor(PA_0);
Timer fileOpenTimer;
 
#define bufferSize 4096
//float sensorReading[bufferSize];
//unsigned int readPointer = 0;
//volatile unsigned int writePointer = 0; // volatile so that the main loop knows to check for changes.

float ADCSamples[bufferSize];
char SampleCount;

void onSampleTick(void)
{
    sensorReading[writePointer++] = sensor; // Unscaled value from 0.0 to 1.0
    if (writePointer == bufferSize)
    {
        writePointer = 0;
    }
    if (writePointer == readPointer) 
    {
        // BUFFER OVERFLOW. You may want to print an error message or turn an LED on
    }
}
 
main()
{
    
    fileOpenTimer.start();
    sampleTicker.attach(&onSampleTick,0.02); // sets the sample period in seconds. Check to see what this time should be?
 
    while (true)
    {
 
        while (writePointer != readPointer) 
        { // write any waiting data to the SD card
            printf(/*myLogFile,*/"%f\n",sensorReading[readPointer++]);
        }
            if (readPointer == bufferSize)
            {
                readPointer = 0;
            }
 
        if (fileOpenTimer > (5*60)) 
        { // file has been open 5 minutes
            fclose(myLogFile); // close the current file
            //myLogFile = nextLogFile(); // open a new file
            if (!myLogFile) 
            {
                break; // exit the while(true) loop
                // ERROR failed to open the log file for writing.
                // card full maybe?
            }
            fileOpenTimer.reset() // restart the timer
        }
    }
}

// opens the next unused file name in the format set.
// This can be a little slow the first time if there are already lots of log files
// since it tries each number in turn but the second call on will be fairly quick.
/*FILE *nextLogFile(void)  //this part creates file write to SD card. MODIFY!!!! to create serial printline *11/1/18
{
    static unsigned int fileNumber = 0;
    char fileName[32];
    FILE *filePtr = NULL;
    do {
        if (filePtr != NULL)
            fclose(filePtr);
        sprintf(fileName,"/sd/log%04u.csv",fileNbr++);
        filePtr = fopen(fileName,"r");
    } while (filePtr != NULL);
    return fopen( fileName,"w");
}*/