#include "mbed.h"
#include "rtos.h"

DigitalIn mySwitch(USER_BUTTON);
AnalogIn analog_value(A0);

Thread thread;

Mutex mutex1;

void print(char * input){
    mutex1.lock();
    printf(input);
    mutex1.unlock();
}


void thread1(){
    float meas;
            
    while(1) {
        char * buff;
        meas = analog_value.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
        float voltage = meas * 3300.0; // Change the value to be in the 0 to 3300 range
        //printf("measure = %.0f mV\n", voltage);
        sprintf(buff, "measure = %.2f mV\n", voltage);
        printf(buff);
        wait(0.50); // 250 ms
    }
}

int main(){
    thread.start(thread1);
    mySwitch.mode(PullUp);
    
    
    char * string1 = "User button is 1 ";
    char * string2 = "User button is 0 ";
    
    while(1){
        if (mySwitch){
            //printf("%s", string1);
            //fflush(stdout);
            print(string1);
        }
        else{
            //printf("%s", string2);
            //fflush(stdout);
            print(string2);
        }
        Thread::wait(0.100);
    }
        thread.join();

    
}