

#ifndef _stepper_h_
#define _stepper_h_

#include "mbed.h"

class Stepper {

public:

    Stepper(PinName Step, PinName Dir, PinName En, PinName Endstop_Left, PinName Endstop_Right, bool Invert_Dir, bool Invert_ESL, bool Invert_ESR);
    
    bool Pulse();
    bool Set_Dir (bool Dir2Set);
    bool ESL_Activeated();
    bool ESR_Activeated();
    bool ESL_Fitted();
    bool ESR_Fitted();
    
    void Enable (bool OnOff);
    
    bool ESL_Port(int PORT_In);         // bit MASK testing of non zero port bits
    
    void ESL_Set_MASK (int Port_MASK_L_in);
    void ESL_Set_INV_MASK (int Port_INV_MASK_L_in);
    
  

protected:
    DigitalOut  _Step;    
    DigitalOut  _Dir;
    DigitalOut  _En;
    
    DigitalIn _Endstop_Left;    
    DigitalIn _Endstop_Right;
    
    
    bool _Invert_Dir;
    bool _Invert_ESL;
    bool _Invert_ESR;
    bool _g4;
    
    bool ESL; 
    int Port_MASK_L;    
  
    
private:
       
    int ESR; 
    int Set; 
    

    int Port_INV_MASK_L;    
    
    };

#endif // _stepper_h_