


#include "mbed.h"
#include "Stepper.h"


/* .......................................

    ? Pars Expanded Byte(s)
    
    Assuming Port expander is used;
    
    then on ISR, read chip registors ..
    -> code -> 
  ........................................  */



Stepper::Stepper(PinName Step, PinName Dir, PinName En, 
                 PinName Endstop_Left, 
                 PinName Endstop_Right, 
                 
                 bool Invert_Dir, 
                 bool Invert_ESL, 
                 bool Invert_ESR)


            : _Step (Step),  _Dir(Dir), _En(En), _Endstop_Left(Endstop_Left), _Endstop_Right(Endstop_Right)
{            

                // Assume End Stop Left is MIN,
                // and End Stop Right is MAX endstop.
                
                 _Invert_Dir = Invert_Dir, 
                 _Invert_ESL = Invert_ESL, 
                 _Invert_ESR = Invert_ESR;            
           
{
    //  bool read_1();
        if (Endstop_Left   != NC) 
        {
            ESL = true; 
            _Endstop_Left.mode (PullUp);
        }
        else 
        {
            ESL = false;
        }
        if (Endstop_Right  != NC) 
        {
            ESR = true; 
            _Endstop_Right.mode (PullUp);
        }
        else 
        {
            ESR = false;
        }
        
        // Set default val;ues .. no potr Endstops
        //Port_MASK_L = 0;
        //Port_INV_MASK_L = 0;

    } 
}  

// ------------------------------------------------------------------------------------


bool Stepper::Pulse()
{
//    if (Step == NC)
//    {
//        return false;
//    }
//    else
        // Enable motor .. if not enabled .. short delay befor moveing ..
        
        if (_En) 
        {
            _En = 0;
            wait (0.005);   // 5 mSec.
        }
        
        _En = 0;
        
        
        {
            _Step = 1;
            wait_us (2);
            _Step = 0;
            return true;
        }
}

// ------------------------------------------------------------------------------------


void Stepper::Enable (bool OnOff)
{
    _En = !OnOff;
}

// ------------------------------------------------------------------------------------

bool Stepper::Set_Dir (bool Dir2Set)
{
//    if (Dir == NC)
//    {
//        return false;
//    }
//    else
    {
        if (Dir2Set)
        {
            _Invert_Dir ? _Dir = 0 : _Dir = 1;
        }
        else
        {
            _Invert_Dir ? _Dir = 1 : _Dir = 0;
        }
        
        return true;
    }
}


// ------------------------------------------------------------------------------------

// test if ENDSTOP is enabled ....  _Endstop_Left

bool Stepper::ESL_Fitted()
{
//    (ESL) ? return true : return false;
    if (ESL) 
    return true;
    else
    return false;
}

//

bool Stepper::ESR_Fitted()
{
    //ESR ? return true : return false;
    if (ESR)
    return true;
    else
    return false;
}

// ...............................................................................

bool Stepper::ESL_Activeated()
{
    bool retval;
    
    if (_Invert_ESL)
    {
        if (_Endstop_Left)  retval = true; else retval = false;
    }
    else
    {
        if (_Endstop_Left)  retval = false; else retval = true; // 
    }
    
    if (retval)
    {
        //StepCount = 0;  // might be very bad for H-BOT
    }
     
    return retval;
}

//

bool Stepper::ESR_Activeated()
{
    if (_Invert_ESR)
    {
        if(_Endstop_Right) return true; else return false;
    }
    else
    {
        if(_Endstop_Right) return false; else return true;
    }
}
// ------------------------------------------------------------------------------------

// test if endstop is triggerd.
// ** will return false if not triggerd AND false if pin is NC
// ** user should test if connected befor in a nested routeen from MAIN !!



bool Stepper::ESL_Port(int PORT_In)
{
    bool Ret = false;
    
    if (!Port_MASK_L)
    {
        Ret = false;
    }
    else
    {
        if (PORT_In && Port_MASK_L)
        {
            (Port_INV_MASK_L) ? Ret = true : Ret = false;
        }
        else
        {
            (Port_INV_MASK_L) ? Ret = false : Ret = true;
        }
    }

    return (Ret);
}


// .............................

    void Stepper::ESL_Set_MASK (int Port_MASK_L_in) 
    {
    Port_MASK_L = Port_MASK_L_in;
    }
    
    void Stepper::ESL_Set_INV_MASK (int Port_INV_MASK_L_in) 
    {
    Port_INV_MASK_L = Port_INV_MASK_L_in;
    }












/*  **********************************************************************

**
*   `   want an entity for a SINGLE Stepper motor, and assosiated things ..

        PINS:
            step,
            Direction,
            Enable,
            
            endstop_left
            endstop_right
            
            Direction_Invert (T/F)
            
        calls:
            step
            Endstop_Detected           
**
*
*
        Vars:
            Number of steps to take
*
*
**
*       also need to be able to tell if endstops are defined
*
*

    if (ESR  != NC) ESR_En = true; else ESR_En = false; // 44;
    
    // got 340 with g1 defined ..
    // got 44 with NO define :)

***************************

        if (Endstop_Right_Enabled)
        {
        
        }
        else
        {
        
        }

* ********************************************************************* */