#include "mbed.h"
#include "USBHID.h"
/*
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
*/
BusOut leds(LED1,LED2,LED3,LED4);
AnalogIn PortA (p20);
AnalogIn PortB (p19);
AnalogIn PortC (p18);
AnalogIn PortD (p17);

int a, x, t, k;
int An_a, An_b, An_c, An_d;

#define HID_MessageSize 18

//This report will contain data to be sent
HID_REPORT send_report;
HID_REPORT recv;

//We declare a USBHID device
USBHID hid_A (HID_MessageSize, HID_MessageSize,0xcbc,0x123,5);     // In Length, Out Length, VID, PID, Release
//USBHID hid_B (HID_MessageSize, HID_MessageSize,0xcbc,0x123,6);


// Strings are in "USBDevice.cpp"


//BusOut leds(LED1,LED2,LED3,LED4);

int main(void) {

    //Fill the report
    for (int i = 0; i < HID_MessageSize; i++)
        send_report.data[i] = i;
    send_report.length = HID_MessageSize;
    
    //jjhhggrr

    while (1) 
    {
        //Send the report

//        if (hid_A.readNB(&recv)) 
        {
            leds = recv.data[0];
            send_report.data[1]++;
            
            // just a test to see how fast send could be ..
            
            for (x=0; x<200;x++)
            {
              
                An_a = PortA.read_u16();
                An_b = PortB.read_u16();
                An_c = PortC.read_u16();
                An_d = PortD.read_u16();
                
                send_report.data[3] = An_a & 0xff;
                send_report.data[2] = An_a >>8;
                
                send_report.data[5] = An_b & 0xff;
                send_report.data[4] = An_b >>8;
                
                send_report.data[7] = An_c & 0xff;
                send_report.data[6] = An_c >>8;
                
                send_report.data[9] = An_d & 0xff;
                send_report.data[8] = An_d >>8;;  
                
                send_report.data[11] = k & 0xff;
                send_report.data[10] = k >>8;    
                
                k++;                                          
                
                send_report.data[16] = x;
                hid_A.send(&send_report);            
            }
            

        }
        send_report.data[HID_MessageSize-2]++;
        hid_A.send(&send_report);
        wait(0.5);
    }
}
