#include "mbed.h"

extern "C" void mbed_mac_address(char *s) 
{
    char mac[6];
    mac[0] = 0x00;
    mac[1] = 0x02;
    mac[2] = 0xf7;
    mac[3] = 0xf0;
    mac[4] = 0x46;
    mac[5] = 0x4b;

    memcpy(s, mac, 6);
}


// the one on my desk ........ 00 02 f7 f0 55 5e
// the one on the fireplace .. 00 02 f7 f0 46 4b

// 00:02:f7:f0:46:4b .. from tweet program ?

// -> http://mbed.org/forum/mbed/topic/972/?page=1#comment-10318

// Going to write the MAC address from one of my MBED's to annother MBED.

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX); // tx, rx  pc.baud(921600);

int main() 
{
    uint64_t uid = 0;
    char mmac[6];
    char mac[6];

    pc.baud(921600);

    pc.printf("Trying to overwrite MAC Address ..\r\n");

    mbed_mac_address(mmac);
    uid = mmac[0] << 40 | mmac[1] << 32 |
          mmac[2] << 24 | mmac[3] << 16 |
          mmac[4] << 8  | mmac[5] << 0;

    pc.printf ("Here it is .. %02x %02x %02x %02x %02x %02x .. \r\n", mmac[0], mmac[1], mmac[2], mmac[3], mmac[4], mmac[5]);

    while (1) 
    {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}



