#include "mbed.h"

extern "C" void mbed_mac_address(char *s);

// -> http://mbed.org/forum/mbed/topic/972/?page=1#comment-10318

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX); 

int main() 
{
    uint64_t uid = 0;
    char mmac[6];
    char mac[6];

    pc.baud(921600);

    pc.printf ("\r\nTrying to read My MAC Address ..\r\n");

    mbed_mac_address(mac);
    uid = mac[0] << 40 | mac[1] << 32 |
          mac[2] << 24 | mac[3] << 16 |
          mac[4] << 8  | mac[5] << 0;

    pc.printf ("Here it is .. %02x %02x %02x %02x %02x %02x !\r\n", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);


    while (1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}


