#include "mbed.h"
#include "SLCD.h"

#define PROGNAME "LightSense_K146z_PWM v1\n\r"
#define DATATIME 400 //milliseconds
#define LCDLEN 10
#define LIGHTSENSORPORT PTE22

SLCD slcd; //define LCD display globally define
Serial pc(USBTX, USBRX);
Timer LEDTimer;

void LCDMess(char *lMess)
{
    slcd.Home();
    slcd.clear();
    slcd.printf(lMess);
}

int main()
{
    PwmOut greenColor(LED_GREEN);
    PwmOut redColor(LED_RED);
    AnalogIn LightSensor(LIGHTSENSORPORT);
    float lightData;
    char lcdData[LCDLEN];
    float max;
    float min = 1.0; 
    int timeToChangeDF = DATATIME;
    // set up tier for next step of Duty Factor timing
    LEDTimer.start();
    LEDTimer.reset();
    pc.printf(PROGNAME);
    
    while (true) {
      if(LEDTimer.read_ms() > timeToChangeDF) { //check for timer
      lightData = (1.0 - LightSensor.read());
      /*
       * IF LIGHT DATA > MAX, 
         MAX VALUE BECOMES THE CURRENT LIGHT DATA
      */
      if (lightData > max)
      {
          max = lightData;
      }
      if(lightData < min)
      {
          min = lightData;
      }
      pc.printf("MAX: %4.3f\r\n", max);
      pc.printf("MIN: %4.3f\r\n", min); 
      greenColor.write(1.0 - lightData);
      redColor.write(1.0 - lightData);
      sprintf(lcdData, "%4.3f", lightData);
      LCDMess(lcdData);
      pc.printf("%4.3f\r\n", lightData);
      timeToChangeDF = DATATIME;
      LEDTimer.reset();
    }
}
}