#include "L25AA02EA48.h"
L25AA02EA48::L25AA02EA48(PinName MOSI, PinName MISO, PinName SCLK, PinName CS) : _serial(MOSI,MISO,SCLK), _cs(CS)
{
    _cs = 1;
    _serial.frequency(2000000);
    _serial.format(8,3);
}

int L25AA02EA48::command(int c)
{
    int response=0;
    _cs = 0;    

    _serial.write(c);
    response = _serial.write(0x0);  //address 0

    _cs = 1;
    return response;
}

int L25AA02EA48::read_address(int a)
{
    int response=0;
    _cs = 0;    

    _serial.write(COMMAND_READ);
    _serial.write(a);  //address 0
    response=_serial.write(0x0);
    _cs = 1;
    return response;
}
char * L25AA02EA48::getMacAddress()
{
//    for (int i=0; i<6; i++)
//        MacAddress[i] = read_address(0xfa+i);
  
    _cs = 0;    
  
    _serial.write(COMMAND_READ);
    _serial.write(0xfa);  //address 0
    for(int i=0; i<6; i++)
        MacAddress[i]=_serial.write(0x0);      
    
    _cs = 1;
    return MacAddress;
}