//Celeritous Technical Services, Corp.  2012
//Mattehw R. Gattis

#include "math.h"
#include "ST7565R.h"
#include "QEI.h"
#include "L25AA02EA48.h"
#include "EthernetNetIf.h"
#include "mbed.h"
#include "defines.h"
#include "HTTPServer.h"
#include "RPCFunction.h"
#include "RPCVariable.h"

ST7565R lcd(p12,p29,p7,p5, p30 , true);
L25AA02EA48 mac_pins(P0_9,P0_8,P0_7,P0_18);        //pins to MAC address chip on breakout board
QEI OE(p14,p28,NC,1,QEI::X4_ENCODING);

//Timer keyttime;
Ticker net_interrupt;
volatile int inputnav;
volatile char *macAddress;
volatile unsigned int ethresult=(~0);
IpAddr ip;
float myObj;
RPCVariable<float> MyVar(&myObj, "MyVar");

EthernetNetIf eth;
HTTPServer svr;
LocalFileSystem fs("webfs");

void print_menu(char **);
void print_sensors(char line);
void main_menu();
void key_handle();
void OE_menu();
void eth_menu();
void gfx_demo();
void net_poll();
void http_setup();

extern "C" void mbed_mac_address(char *mac) {    //calling my own mbed_mac_address function to use the Breakout board's MAC chip
    for (int i=0; i<6; i++) {mac[i] = macAddress[i];}
}

int main()
{
    MyVar.write(3.14159);
    NAV_UP_int.fall(&key_handle);
    NAV_LEFT_int.fall(&key_handle);
    NAV_DOWN_int.fall(&key_handle);
    NAV_RIGHT_int.fall(&key_handle);
    NAV_PRESS_int.fall(&key_handle);
    //keyttime.start();
    main_menu();
}

void print_menu(char **buffer) {
    char i;
    for (i=0;i<4;i++) {
        lcd.moveto(2,i);
        lcd.printf("%s",buffer[i]);
    }
}

void print_sensors(signed char line) {
    AnalogIn vtemp(p15);
    AnalogIn vrh(p16);
    AnalogIn vlight(p17);
    float temp;
    
    temp=0.1*(vtemp.read()*3300)-60;
    if (line<=1) {lcd.moveto(9,1-line);lcd.printf("%0.2f C",temp);}
    if (line<=2) {lcd.moveto(9,2-line);lcd.printf("%0.2f %%",((25*(20000*(3.3*vrh.read())-9999))/10494)/(1.0546-0.0026*temp));}
    if (line<=3) {lcd.moveto(9,3-line);lcd.printf("%0.2f lux",0.0003f*pow(2.71828183f,9.2f*(1.6f-(3.3f*vlight.read()))));}
    return;
}

void main_menu() {
    char *buffer[]={"Web Server","Temp :","Humid:","Light:","Optical Encoder","Graphics Demo"};
    signed char cursor=0,line=0;
    
    while (1) {
        lcd.clearBuffer();
        if (cursor>line+2) {line=cursor-2;}
        if (cursor<=line) {line=cursor-1;}
        if (line<0) {line=0;}
        if (line>2) {line=2;}
        print_menu(&buffer[line]);
        print_sensors(line);
        lcd.moveto(0,cursor-line);
        lcd.printf("->");
        lcd.swapBuffers();
        if (inputnav&NAV_UP && cursor>0) {cursor--;}
        if (inputnav&NAV_DOWN && cursor<5) {cursor++;}
        if (inputnav==NAV_PRESS && cursor==4) {OE_menu();}
        if (inputnav==NAV_PRESS && cursor==0) {eth_menu();}
        if (inputnav==NAV_PRESS && cursor==5) {gfx_demo();}
        inputnav=0;
        wait_ms(20);
    }
}

void key_handle() {
    wait_ms(20);
    /*if (keyttime.read_ms()>100) {*/inputnav=(~NAVIn.read())&0x1F;//keyttime.reset();}
}

void OE_menu() {
    PwmOut led(LED1);
    char *buffer[]={"","","OE Pulse:","Back"};
    char i,j,cursor=2;
    int last_pulse=0;
    int pulse=0;
    float output=0.0;
    
    OE.reset();
    while (1) {
        lcd.clearBuffer();

        print_menu(buffer);
        lcd.moveto(0,cursor);
        lcd.printf("->");

        lcd.moveto(12,2);
        lcd.printf("%d",pulse);
        output=-((float)pulse)/128;
        if (output>1.0f) {output=1.0f;}
        if (output<0.0f) {output=0.0f;}
        led=output;
        for (j=0;j<(int)(output*128);j++) {
            for (i=0;i<7;i++) {
                lcd.clearpixel(j,i);
            }
        }

        lcd.swapBuffers();

        inputnav=0;
        while (!inputnav && pulse==last_pulse) {pulse=OE.getPulses();}
        if (inputnav&NAV_UP && cursor>2) {cursor--;}
        if (inputnav&NAV_DOWN && cursor<3) {cursor++;}
        if (inputnav==NAV_PRESS && cursor==3) {
            wait_ms(200);
            led=0.0f;
            inputnav=0;
            return;
        }
        
        last_pulse=pulse;
    }
}

void gfx_demo() {  
    unsigned int iteration=0;
    unsigned int pixel=0;    
    
    unsigned int x=0;
    unsigned int y=0;
    
    inputnav=0;
    while(inputnav!=NAV_PRESS) 
    {
    
        lcd.clearBuffer();
        wait_ms(30);
        for(int i=0; i<32; i++)
        {
            for (int j=0; j<128; j++)
            {
                pixel = (i+iteration+y)*(j+iteration+x);
                pixel &= 15;
                                                   
                if (pixel == 0) lcd.clearpixel(j,i);
            }
        }

        iteration++;
        lcd.swapBuffers();
    }
    wait_ms(200);
    inputnav=0;
}

void eth_menu() {
    lcd.clearBuffer();
    if (ethresult==(~0)) {
        lcd.moveto(0,0);lcd.printf("Initializing...");
        lcd.swapBuffers();
        lcd.clearBuffer();
        macAddress=mac_pins.getMacAddress();
    }
    lcd.moveto(0,0);
    lcd.printf("Mac:%02X:%02X:%02X:%02X:%02X:%02X", macAddress[0], macAddress[1], macAddress[2], macAddress[3], macAddress[4], macAddress[5]);
    lcd.moveto(0,1);
    if (ethresult==(~0)) {ethresult=eth.setup();}
    if (ethresult==ETH_OK) {
        ip=eth.getIp();
        lcd.printf("IP :%d.%d.%d.%d",ip[0],ip[1],ip[2],ip[3]);
        http_setup();
        net_interrupt.attach_us(&net_poll,2000);
    }
    else {
        lcd.printf("ERROR on startup!");
        lcd.moveto(0,2);
        lcd.printf("Reset and try again.");
    }
    lcd.moveto(0,3);
    lcd.printf("->Back");
    lcd.swapBuffers();
    inputnav=0;
    //simply wait for the user to press the middle nav key
    while (inputnav!=NAV_PRESS) {wait_ms(20);}
    wait_ms(200);
    inputnav=0;
    return;
}

void net_poll() {
    Net::poll();
}

void http_setup() {
    Base::add_rpc_class<AnalogIn>();

    FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path

    svr.addHandler<RPCHandler>("/rpc");
    svr.addHandler<FSHandler>("/"); //Default handler

    svr.bind(80);
}