#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx

int main() {
    int Fin = 12000000; // 12MHz XTAL
    
    pc.baud(921600);

    pc.printf("PLL Registers:\n");
    pc.printf(" - PLL0CFG = 0x%08X\n", LPC_SC->PLL0CFG);
    pc.printf(" - CLKCFG  = 0x%08X\n", LPC_SC->CCLKCFG);
    
    int M = (LPC_SC->PLL0CFG & 0xFFFF) + 1;
    int N = (LPC_SC->PLL0CFG >> 16) + 1;
    int CCLKDIV = LPC_SC->CCLKCFG + 1;

    pc.printf("Clock Variables:\n");
    pc.printf(" - Fin = %d\n", Fin);
    pc.printf(" - M   = %d\n", M);
    pc.printf(" - N   = %d\n", N);
    pc.printf(" - CCLKDIV = %d\n", CCLKDIV);

    int Fcco = (2 * M * 12000000) / N;
    int CCLK = Fcco / CCLKDIV;

    pc.printf("Clock Results:\n");
    pc.printf(" - Fcco = %d\n", Fcco);
    pc.printf(" - CCLK = %d\n", CCLK);
    
    while(1);
}
