/*******************************************************************************
4D LABS PTY. LTD. COPYRIGHT 2009.
THIS SOFTWARE IS PROVIDED "AS IS." 4D LABS EXPRESSLY DISCLAIM ANY WARRANTY OF
ANY KIND, WHETHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR NONINFRINGEMENT.
IN NO EVENT SHALL 4D LABS BE LIABLE FOR ANY INCIDENTAL, SPECIAL,
INDIRECT OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, HARM TO YOUR
EQUIPMENT, COST OF PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY
CLAIMS BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENCE THEREOF), ANY
CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER SIMILAR COSTS.
*******************************************************************************/
/*******************************************************************************
Name: GOLDELOX-SGC Host Serial Commands Definitions
File Name: GSGCdef.h
Description: Host Serial Interface Commands Definitions
*******************************************************************************/
#ifndef GSGC_DEF_H
#define GSGC_DEF_H
// GSGC PROTOCOL CONSTANTS
#define ACK 0x06 // Acknowledge
#define NAK 0x15 // Not Acknowledge
// GSGC SWITCH-JOYSTICK CONSTANTS
#define SW1_UP 0x10 // SW1 or Joystick UP
#define SW2_LEFT 0x20 // SW2 or Joystick LEFT
#define SW3_DOWN 0x30 // SW3 or Joystick DOWN
#define SW4_RIGHT 0x40 // SW4 or Joystick RIGHT
#define SW5_FIRE 0x50 // SW5 or Joystick FIRE
// GSGC GRAPHICS CONSTANTS
#define COLOR8 0x08 // 8 bit Colour Mode
#define COLOR16 0x10 // 16 bit Colour Mode
#define BUTTONUP 0x01 // Button Up Mode
#define BUTTONDOWN 0x00 // Button Down Mode
#define RED 0xF800 // RED
#define GREEN 0x07E0 // GREEN
#define BLUE 0x001F // BLUE
#define BLACK 0x0000 // BLACK
#define WHITE 0xFFFF // WHITE
// GSGC TEXT CONSTANTS
#define FONT1 0x00 // 5x7 Internal Font
#define FONT2 0x01 // 8x8 Internal Font
#define FONT3 0x02 // 8x12 Internal Font
// GSGC GENERAL COMMANDS DEFINITIONS
#define GSGC_AUTOBAUD 0x55 // Auto Baud Command
#define GSGC_VERSION 0x56 // Device Info Request
#define GSGC_BACKGND 0x42 // Change Background Colour
#define GSGC_CLS 0x45 // Clear Screen
#define GSGC_DISPCONT 0x59 // Display Control Functions
#define GSGC_SWITCHSTAT 0x4A // Get Switch-Buttons Status
#define GSGC_SWITCHSTATWAIT 0x6A // Get Switch-Buttons Status with Timeout
#define GSGC_SOUND 0x4E // Generate a Tone
// GSGC GRAPHICS COMMANDS DEFINITIONS
#define GSGC_ADDBM 0x41 // Add User Bitmap
#define GSGC_CIRCLE 0x43 // Draw Circle
#define GSGC_BM 0x44 // Draw User Bitmap
#define GSGC_TRIANGLE 0x47 // Draw Triangle
#define GSGC_IMAGE 0x49 // Draw Image-Icon
#define GSGC_LINE 0x4C // Draw Line
#define GSGC_PIXEL 0x50 // Draw Pixel
#define GSGC_RDPIXEL 0x52 // Read Pixel
#define GSGC_SCRNCOPYPASTE 0x63 // Screen Copy-Paste
#define GSGC_POLYGON 0x67 // Draw Polygon
#define GSGC_SETPEN 0x70 // Set Pen Size
#define GSGC_RECTANGLE 0x72 // Draw Rectangle
// GSGC TEXT COMMANDS DEFINITIONS
#define GSGC_SETFONT 0x46 // Set Font
#define GSGC_SETOPAQUE 0x4F // Set Transparent-Opaque Text
#define GSGC_STRINGGFX 0x53 // “String” of ASCII Text (graphics format)
#define GSGC_CHARTXT 0x54 // ASCII Character (text format)
#define GSGC_BUTTONTXT 0x62 // Text Button
#define GSGC_STRINGTXT 0x73 // “String” of ASCII Text (text format)
#define GSGC_CHARGFX 0x74 // ASCII Character (graphics format)
// GSGC EXTENDED COMMANDS HEADER DEFINITION
#define GSGC_EXTCMD 0x40 // Extended Command Header
// GSGC MEMORY CARD COMMANDS DEFINITIONS
#define GSGC_MCAP 0x41 // Set Address Pointer of Memory Card
#define GSGC_MCCOPYSAVE 0x43 // Screen Copy-Save to Memory Card
#define GSGC_MCIMAGE 0x49 // Display Image-Icon from Memory Card
#define GSGC_MCOBJ 0x4F // Display Object from Memory Card
#define GSGC_MCRUN 0x50 // Run Script (4DSL) Program from Card
#define GSGC_MCRDSECTOR 0x52 // Read Sector Block Data from Memory Card
#define GSGC_MCVIDEO 0x56 // Display Video Clip from Memory Card
#define GSGC_MCWRSECTOR 0x57 // Write Sector Block Data to Memory Card
#define GSGC_MCINIT 0x69 // Initialise Memory Card
#define GSGC_MCRDBYTE 0x72 // Read Byte Data from Memory Card
#define GSGC_MCWRBYTE 0x77 // Write Byte Data to Memory Card
// GSGC SCRIPTING COMMANDS DEFINITIONS
#define GSGC_MCAP 0x41 // Set Address Pointer of Memory Card
#define GSGC_DELAY 0x07 // Delay
#define GSGC_SETCNTR 0x08 // Set Counter
#define GSGC_DECCNTR 0x09 // Decrement Counter
#define GSGC_JMPNZ 0x0A // Jump to Address If Counter Not Zero
#define GSGC_JMP 0x0B // Jump to Address
#define GSGC_EXIT 0x0C // Exit-Terminate Script Program
// DIVERS
#define SOLID 0
#define EMPTY 1
#define TRANSPARENT 0
#define OPAQUE 1
#define UP 1
#define DOWN 0
#endif