
// C.Dupaty 09/2010 adaptation STM32 03/2021
// demo gestion afficheur graphique uOLED-128-G1 (SGC)
// les équivalences (#define) des commandes sont dans GSGCdef.h
// le descritif des commande uOLED est dans : GOLDELOX-SGC-COMMANDS-SIS-rev3.pdf
// le description des connexions et utilitaires uOLED sont dans : uOLED-128-G1SGC-DS-rev4.pdf
// La carte uSD a été chargé depuis un PC avec 3 images et une vidéo à partir de l'utilitaire GraphicsComposer.exe
// ce dernier a genere un fichier test.txt qui contient entre autre les adresses de ce objets dans la mémoire uSD

// PC_1 : TX (donc RX de uOLED)
// PC_0 : RX (donc TX de uOLED)
// VSS : 0v
// GND : 5v
// VDD : Reset uOLED

#include "mbed.h"
#include <stdio.h>  

#include "uOLEDLIB.h"

DigitalOut myled(LED1);
DigitalIn bouton(USER_BUTTON);
DigitalOut reset(PB_0);
Serial pc(USBTX, USBRX); // tx, rx
Serial uOLED(PC_1,PC_0); // tx, rx

#define OMER    0x014120 // adresses des images dans la uSD (voir fichier test.txt)
#define debug 

char chaine1[]="Test uOLED-128-G1 (SGC)";
char chaine2[]="presser bouton bleu";

unsigned char ack(void)
{
unsigned char resp;
    while (!uOLED.readable()) wait_ms(1);              // wait for screen answer
    resp = uOLED.getc();
    #ifdef debug
    if(resp!=ACK) pc.printf("erreur d acquitement\n");
    else printf("Acquitement OK\n");
    #endif
    return(resp);
}


void couleur_fond(int color)
{
    #ifdef debug
    pc.printf("Commande GSGC_BACKGND %d\n",color);
    #endif
    uOLED.putc(GSGC_BACKGND);
    uOLED.putc(color>>8);
    uOLED.putc(color&0x00FF);
    ack();
}

void rectangle(unsigned char x1,unsigned char y1,unsigned char x2,unsigned char y2,unsigned int color)
{
    #ifdef debug
    pc.printf("Commande GSGC_RECTANGLE , %d, %d, %d, %d\n",x1,y1,x2,y2,color);
    #endif
    uOLED.putc(GSGC_RECTANGLE);
    uOLED.putc(x1);
    uOLED.putc(y1); 
    uOLED.putc(x2);
    uOLED.putc(y2);
    uOLED.putc(color>>8);
    uOLED.putc(color&0x00FF);
    ack();
}

void cercle(unsigned char x,unsigned char y,unsigned char radius,unsigned int color)
{
    #ifdef debug
    pc.printf("Commande GSGC_CIRCLE , %d, %d, %d, %d\n",x,y,radius,color);
    #endif
    uOLED.putc(GSGC_CIRCLE);
    uOLED.putc(x);
    uOLED.putc(y);  
    uOLED.putc(radius);
    uOLED.putc(color>>8);
    uOLED.putc(color&0x00FF);
    ack();
}

void triangle(unsigned char x1,unsigned char y1,unsigned char x2,unsigned char y2,unsigned char x3,unsigned char y3,unsigned int color)
{
    #ifdef debug
    pc.printf("Commande GSGC_TRIANGLE , %d, %d, %d, %d, %d, %d, %d\n",x1,y1,x2,y2,x3,y3,color);
    #endif
    uOLED.putc(GSGC_TRIANGLE);
    uOLED.putc(x1);
    uOLED.putc(y1);
    uOLED.putc(x2);
    uOLED.putc(y2);
    uOLED.putc(x3);
    uOLED.putc(y3);
    uOLED.putc(color>>8);
    uOLED.putc(color&0x00FF);
    ack();
}

void ligne(unsigned char x1,unsigned char y1,unsigned char x2,unsigned char y2,unsigned int color)
{
    #ifdef debug
    pc.printf("Commande GSGC_LINE , %d, %d, %d, %d\n",x1,y1,x2,y2,color);
    #endif
    uOLED.putc(GSGC_LINE);
    uOLED.putc(x1);
    uOLED.putc(y1);
    uOLED.putc(x2);
    uOLED.putc(y2);
    uOLED.putc(color>>8);
    uOLED.putc(color&0x00FF);
    ack();
}

void opaque(unsigned char mode)
{
    #ifdef debug
    pc.printf("Commande GSGC_SETOPAQUE , %d\n",mode);
    #endif
    uOLED.putc(GSGC_SETOPAQUE);
    uOLED.putc(mode);
    ack();
}

void pixel(unsigned char x1,unsigned char y1,unsigned int color)
{
    #ifdef debug
    pc.printf("Commande GSGC_PIXEL , %d, %d\n",x1,y1,color);
    #endif
    uOLED.putc(GSGC_PIXEL);
    uOLED.putc(x1);
    uOLED.putc(y1);
    uOLED.putc(color>>8);
    uOLED.putc(color&0x00FF);
    ack();
}

void penSize(unsigned char size)
{
    #ifdef debug
    pc.printf("Commande GSGC_SETPEN , %d\n",size);
    #endif
    uOLED.putc(GSGC_SETPEN);
    uOLED.putc(size);
    ack();
}

void afftexte_graphic(char x, char y, char font,int color , char w, char h, char * mess)
{
    #ifdef debug
    pc.printf("Commande GSGC_STRINGGFX , %d, %d, %d, %d,%d, %d, %s\n",x,y,font,color,w,h,mess);
    #endif
    uOLED.putc(GSGC_STRINGGFX);
    uOLED.putc(x);
    uOLED.putc(y);
    uOLED.putc(font);
    uOLED.putc(color>>8);
    uOLED.putc(color&0x00FF);
    uOLED.putc(w);
    uOLED.putc(h);
    uOLED.printf("%s",mess);
    uOLED.putc(0);
    ack();
}

void afftexte_text(char x,char y,char font,int color,char* mess)
{
    #ifdef debug
    pc.printf("Commande GSGC_STRINGTXT , %d, %d, %d, %d, %s\n",x,y,font,color,mess);
    #endif
    uOLED.putc(GSGC_STRINGTXT);
    uOLED.putc(x);
    uOLED.putc(y);
    uOLED.putc(font);
    uOLED.putc(color>>8);
    uOLED.putc(color&0x00FF);
    uOLED.printf("%s",mess);
    uOLED.putc(0);
    ack();
}

void affiche_image(char x, char y, char w, char h, char color, unsigned long ad)
{
    #ifdef debug
    pc.printf("Commande GSGC_MCIMAGE , %d, %d, %d, %d, %d, %X\n",x,y,w,h,color,ad);
    #endif
    uOLED.putc('@');
    uOLED.putc(GSGC_MCIMAGE);
    uOLED.putc(x);
    uOLED.putc(y);
    uOLED.putc(w);
    uOLED.putc(h);
    uOLED.putc(color);
    uOLED.putc(ad>>16);
    uOLED.putc((ad>>8)&0x0000FF);
    uOLED.putc(ad&0x0000FF);
    ack();
}

void affiche_video(char x, char y, char w, char h, char color, char delay, int frames,unsigned long ad)
{
    #ifdef debug
    pc.printf("Commande GSGC_MCVIDEO , %d, %d, %d, %d, %d ,%d %d, %X\n",x,y,w,h,color,delay,frames,ad);
    #endif
    uOLED.putc('@');
    uOLED.putc(GSGC_MCVIDEO);
    uOLED.putc(x);
    uOLED.putc(y);
    uOLED.putc(w);
    uOLED.putc(h);
    uOLED.putc(color);
    uOLED.putc(delay);
    uOLED.putc(frames>>8);
    uOLED.putc(frames&0x00FF);
    uOLED.putc(ad>>16);
    uOLED.putc((ad>>8)&0x0000FF);
    uOLED.putc(ad&0x0000FF);
    ack();
}

void txtBouton(char state, char x, char y, int color, char font, int textcolor, char w, char h, char *s)
{
    #ifdef debug
    pc.printf("Commande GSGC_BUTTONTXT , %d, %d, %d, %d, %d ,%d %d, %d, %X, %d\n",state,x,y,color,font,textcolor,w,h,s);
    #endif   
    uOLED.putc(GSGC_BUTTONTXT);
    uOLED.putc(state);
    uOLED.putc(x);
    uOLED.putc(y);
    uOLED.putc(color>>8);
    uOLED.putc(color&0x00FF);
    uOLED.putc(font);
    uOLED.putc(textcolor>>8);
    uOLED.putc(textcolor&0x00FF);
    uOLED.putc(w);
    uOLED.putc(h);
    uOLED.printf("%s",s);
//    uOLED.putc(0);
    ack();
}

void efface(void)
{
        #ifdef debug
        pc.printf("Commande GSGC_CLS\n");
        #endif
        uOLED.putc(GSGC_CLS);       // efface ecran 
        ack();
        wait(0.1);
}


void inituOLED(void)
{
    reset=0;
    wait(0.1);
    reset=1;
    wait(1.0);
    uOLED.putc(GSGC_AUTOBAUD);   // autobaud
    uOLED.putc(GSGC_AUTOBAUD);
}


int main(void)
{
unsigned char resp;  
    #ifdef debug
        pc.printf("Demo uOLED\n");
        pc.printf("Mode debug actif\n");
    #endif  
    inituOLED();
    while(1)
    {   
        efface();
        uOLED.putc(GSGC_VERSION);   // affiche infos uOLED
        uOLED.putc(0x01);           // sur ecran et serial
        while (uOLED.readable()) 
            {
                resp = uOLED.getc(); // vide buffer
                wait_ms(5); 
            }
        wait(1.0);

        efface();
        rectangle(10,10,100,80,RED); // affiche un rectangle rouge plein
        penSize(EMPTY);
        rectangle(40,40,110,110,WHITE); 
        penSize(SOLID);
        cercle(50,90,30,BLUE); // affiche un cercle bleu plein
        triangle(50,10,10,40,100,70,WHITE);
        wait(1.0);

        efface();
        ligne(10,10,100,100,RED);
        ligne(10,100,100,10,BLUE);
        pixel(30,60,WHITE);
        pixel(90,150,GREEN);
        wait(1.0);
        
        efface();
        afftexte_text(2,2,FONT3,RED,chaine1); // affiche un texte formate 
        wait(1.0);

        efface();
        afftexte_graphic(10,12,FONT2,GREEN,2,2,chaine1); // affiche un texte graphique
        wait(1.0);
        
        efface();      
        couleur_fond(WHITE);
 //     txtBouton(UP,5,30,RED,FONT1,WHITE,10,5,"BTN Bleu");
         
        efface();
        afftexte_text(2,2,FONT1,RED,chaine1); // affiche un texte formate 
        opaque(OPAQUE);
        afftexte_text(2,30,FONT3,BLUE,chaine2);    
        opaque(TRANSPARENT);
        pc.printf("recommencer : bouton bleu\n");  
        while(bouton);
        while(!bouton);
        
        couleur_fond(BLACK);
     /*   
        efface();
        affiche_image(0,0,0x80,0x80,COLOR16,OMER); // OMER
        wait(1.0);
    */
    }
    return 0;
}
    
    