// uOLED demo tested on uOLED-128-G1
// from a work or Aaron Goslin https://os.mbed.com/users/Nakor/code/uOLED/docs/tip/ 
// adapted on uOLED-128-G1 by Christian Dupaty 03-2021
// clor code can be found here : http://www.littlewebhut.com/css/value_color/ 
// or here : https://www.mathsisfun.com/hexadecimal-decimal-colors.html


#include "mbed.h"
#include "uOLED.h"
DigitalOut myled(LED1);
Serial pc(USBTX, USBRX); // tx, rx
uOLED SGC(PC_1, PC_0, PB_0);

int main()
{
    while(1) {
        SGC.eraseScreen();
        SGC.drawCircle(0x3F, 0x3F, 0x22, 0x00, 0xFF, 0x00);
        wait(1);
        SGC.drawText(1, 50, 2, 0xFF, 0x0F, 0x55, "uOLED-128-1");
        wait(1);
        int i,j;
        for(i=10;i<50;i++)
        {
            for(j=20;j<80;j+=3)
            SGC.putPixel(i, j, 255, 255,255);
        }
        wait(1);
        SGC.drawCharacter('A', 50, 20, 0xFF, 0,0);
        wait(1);
        SGC.drawLine(10,10,100,100, 0,0,0xFF);
        wait(1);
        SGC.drawRectangle(60,60, 70, 60, 50,50,50);
        wait(1);
        SGC.textMode(0);
        SGC.drawText(10,10,0, 0xFF,128,0xFF,"Bonjour");
        wait(1);
        SGC.textMode(1);
        SGC.drawTextUF(5,25, 1, 0,0,0xFF, 4,4, "uOLED");
        wait(1);
        SGC.eraseScreen();
        SGC.drawTriangle(50,10,10,80,100,70,0xFF,0xFF,0);
        wait(1);
        SGC.penSize(1);
        SGC.drawRectangle(40,40, 70, 60, 0xFF,0xFF,0xFF);
        SGC.penSize(0);
        wait(1);
        SGC.setBackgroundColour(0xFF,0,0);
        SGC.eraseScreen();
        SGC.drawText(1, 1,OLED_FONT5X7, 0x80, 0x0F, 0xA0, "FONT5X7");
        SGC.drawText(1, 3, OLED_FONT8X8, 0x80, 0x0F, 0xB0, "FONT8X8");
        SGC.drawText(1,6, OLED_FONT8X12, 0x80, 0x0F, 0xFF, "FONT8X12");
        wait(1);
        SGC.setBackgroundColour(0,0,0);
        wait(1);
    }
}
