// essai LPC1768 sut carte TESTBED
// http://www.lextronic.fr/P22450-platine-devaluation-testbed.html
// test IO, ADC, serial, LCD, interrupt

#include "mbed.h"
#include "TextLCD.h"

// LED1 = P5.5  LED2 = P5.6  sur carte testbed
// 2 Leds sur carte testBed
DigitalOut ledG(p6);
DigitalOut ledR(p5);

// Potentiomètre sur p15 (carte testbed)
AnalogIn pot(p15);

// le port serie emulé sur la connexion USB (USBTX et USBRX), necessite un driver sous Windows
Serial pc(USBTX, USBRX);

//the object "lcd" is initialized to act as a TextLCD with 20x4 characters
TextLCD lcd(p26, p25, p24, p23, p22, p20, p19, TextLCD::LCD20x4);

// interruption sur BTN1
InterruptIn btn1(p8);

// IT periodique
Ticker tempo;

// prototypes fonctions d'IT
void BTN1_interruption();
void Rx_interruption();
void flash_interruption();

int main()
{
    //each line of the LCD can be accessed directly using the .locate(column, line) function
    lcd.locate(0,0);
    lcd.printf("Tests mbed");
    lcd.locate(0,1);
    lcd.printf("---------");
    lcd.locate(0,2);
    lcd.printf("CD.01-2015");
    lcd.locate(5,3);
    lcd.printf("LLAP");
    wait(1);

    //the LCD is cleared using function .cls()
    lcd.cls();
    // communications
    pc.baud(9600);

    // interruption sur RX
    pc.attach(&Rx_interruption);

    // interruption sur BTN1 front descendant, appui
    btn1.fall(&BTN1_interruption);

    // IT sur timer toutes les 0,5s
    tempo.attach_us(&flash_interruption, 500000);

    while(1) {
        lcd.locate(0,0);
        lcd.printf("pot=%f %d   \n",pot.read(),pot.read_u16 ());
        lcd.printf("BTN1:IT RXIT affiche\n");
        pc.printf("pot=%f %d\n",pot.read(),pot.read_u16 ());
        wait(0.5);
    }
    //__WFI();
}

void BTN1_interruption()
{
    static char c=0;
    if (!c) {
        lcd.locate(5,3);
        lcd.printf("INTERRUPTION");
    } else {
        lcd.locate(5,3);
        lcd.printf("            ");
    }
    c=~c;
    pc.printf("\n  ------------INTERRUPTION BTN1----------\n");
    return;
}

void Rx_interruption()
{
    lcd.locate(5,3);
    lcd.printf("%c            ",pc.getc());
    return;
}

void flash_interruption()
{
    ledG=!ledG;
    ledR=!ledG;
    return;
}