/*
    Copyright (c) 2010 Andy Kirkham
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
*/

#include "mbed.h"
#include "OSD7456.h"

void
OSD7456::init(void)
{
    for (int i = 0; i < OSD_NUM_LINES; i++) { clear(i); } 
    oddEven = false;   
    max7456->vsync_set_callback(this, &OSD7456::vsync);
}

void
OSD7456::clear(int line)
{
    lines[line].updated = true;
    memset(lines[line].line, ' ', OSD_LINE_LEN);
    memset(lines[line].attrib, 0, OSD_LINE_LEN);
}

void 
OSD7456::vsync(void)
{
    if (oddEven) {
        oddEven = false;
    }
    else {
        for (int i = 0; i < OSD_NUM_LINES; i++) {
            if (lines[i].updated) {
                max7456->stringxy(0, i, lines[i].line, lines[i].attrib);
                lines[i].updated = false;
            }
        }
        oddEven = true;
        cb_vsync.call();
    }
}

int 
OSD7456::print(int line, char *s) 
{ 
    int i = 0; 
    while (*s != '\0') { 
        lines[line].line[i] = *s; 
        s++; i++; 
    } 
    lines[line].updated = true; 
    return i; 
}
 
int 
OSD7456::print(int line, char *s, char attrib) 
{ 
    int i = 0; 
    while (*s != '\0') { 
        lines[line].line[i] = *s; 
        lines[line].attrib[i] = attrib; 
        s++; i++; 
    } 
    lines[line].updated = true; 
    return i; 
}

int 
OSD7456::print(int x, int y, char *s) 
{ 
    int i = 0; 
    while (*s != '\0') { 
        lines[y].line[i+x] = *s; 
        s++; i++; 
    } 
    lines[y].updated = true; 
    return i; 
}

int 
OSD7456::print(int x, int y, char *s, char attrib) 
{ 
    int i = 0; 
    while (*s != '\0') { 
        lines[y].line[i+x] = *s; 
        lines[y].attrib[i+x] = attrib; 
        s++; i++; 
    } 
    lines[y].updated = true; 
    return i; 
}
