/* C.Dupaty 
* 03-2018
* Demo MAX7219 library on MIKROELEKTRONIKA Serial 7-Seg Display 8-Digit
* https://www.mikroe.com/serial-7-seg-8-digit-board  
* https://www.maximintegrated.com/en/products/power/display-power-control/MAX7219.html 
* see library here https://os.mbed.com/teams/Maxim-Integrated/code/MAX7219/ 
*/

#include "mbed.h"
#include "max7219.h"

Max7219 max7219(SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS);  // satndard SPI on NUCLEO BOARD

// print decimal number on the display
void affN(unsigned int n)
{
// 7 segments code for print numbers [0..9] see MAX7219 datasheet 
const unsigned char code7seg[]={0x7E,0x30,0x6D,0x79,0x33,0x5B,0x5F,0x70,0x7F,0x7B};
  int i = 1;
  while (n != 0)
    {
      max7219.write_digit(1, i++, code7seg[n % 10]);
      n /= 10;
    }
   while(i<9) max7219.write_digit(1, i++, code7seg[0]);
}

int main()
{
int nb=0;
    max7219_configuration_t cfg = {
        .device_number = 1,                         // device number (only one in this demo)
        .decode_mode = 0,                           // mode 0, no decode (see MAX7219 datasheet page 7)
        .intensity = Max7219::MAX7219_INTENSITY_4,  // intensity of light ( 1 to 8)
        .scan_limit = Max7219::MAX7219_SCAN_8       // nb of digits to print
    };
    max7219.init_device(cfg);
    max7219.enable_device(1);
    max7219.set_display_test();     // flash all segments for test
    wait(1);
    max7219.clear_display_test();
    // a simple 32 bits counter
    while (1) {
         affN(nb++);
         if(nb>=4000000000) nb=0; // for example
        wait(0.1);   
    }
}
