/*******************************************************************************
 * Copyright (c) 2014, 2015 IBM Corp.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *
 * The Eclipse Public License is available at
 *    http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 *   http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *    Ian Craggs - initial API and implementation and/or initial documentation
 *    Ian Craggs - make sure QoS2 processing works, and add device headers
 *
 * Adaptation STM32 NUCLEO and mosquitto.org : C.Dupaty
 * 06/2020
 * 
 This demo works on NUCLEO STM32.
WIFI link with ESP8266 connected
Configuration in mbed_app.json
target_overrides for the UART connection of the ESP8266 and the WIFI connection (SSID / PASS)
MQTT parameters are configured in #define below
if receive payload with first q -> exit
if receive payload with first l -> toggle LED1 on NUCLEO
 * 
 *******************************************************************************/

#include "easy-connect.h"
#include "MQTTNetwork.h"
#include "MQTTmbed.h"
#include "MQTTClient.h"

DigitalOut led(LED1);
Serial pc(USBTX, USBRX);

#define board "NUCLEO_F411RE"
/*
MQTT QOS,  There are 3 QoS levels in MQTT
At most once (MQTT::QOS0)
At least once (MQTT::QOS1)
Exactly once (MQTT::QOS2).
*/
#define quality MQTT::QOS0
/*
retained flag : The broker stores the last retained message and the corresponding QoS for that topic. 
Each client that subscribes to a topic pattern that matches the topic of the retained 
message receives the retained message immediately after they subscribe. 
The broker stores only one retained message per topic.
*/
#define ret false
/*
dup flag : The flag indicates that the message is a duplicate 
and was resent because the intended recipient (client or broker) did not acknowledge the original message.
*/
#define dupli false

//DigitalIn btn(USER_BUTTON); //PC13 sur F411
DigitalIn btn(PA_8,PullUp);   // button connected with internal pullup

const char* hostname = "test.mosquitto.org";
const int port = 1883;
char* ID ="mbedSTM32Fourcade";
char* user =NULL;       // user & pass = NULL for broker with no credential.   
char* pass =NULL;
const char* topic = "topic0";
int arrivedcount=0;
bool quit=false;

NetworkInterface* network = easy_connect(true);
MQTTNetwork mqttNetwork(network);
MQTT::Client<MQTTNetwork, Countdown> client(mqttNetwork);
MQTT::Message message;
MQTTPacket_connectData data = MQTTPacket_connectData_initializer;

void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    pc.printf("\x1B[33m");   // yellow
    pc.printf("Message arrived -> qos %d, retained %d, dup %d, packetid %d\r\n", message.qos, message.retained, message.dup, message.id);
    pc.printf("Payload -> %.*s\r\n", message.payloadlen, (char*)message.payload);
    ++arrivedcount;    
    if (*(char*)message.payload=='q') 
                    {
                    pc.printf("\x1B[31m");   // red
                    pc.printf("Exit command received\n\r");    
                    quit=true;
                    }
    if (*(char*)message.payload=='l') 
                    {
                    led=!led;
                    pc.printf("\x1B[31m");   // red
                    pc.printf("toggle LED\n\r");
                    }
    pc.printf("\x1B[0m"); // raz
}

void connection(void)
{
int rc;
    pc.printf("\x1B[32m");   // green
    pc.printf("Connecting to MQTT broker %s:%d\r\n", hostname, port);
   
    if ((rc = client.connect(data)) != 0)
        pc.printf("rc from MQTT connect is %d\r\n", rc);
    else pc.printf("connection MQTT OK ID:%s USER:%s PASS:%s\r\n",ID,user,pass);

    if ((rc = client.subscribe(topic, quality, messageArrived)) != 0)
        pc.printf("rc from MQTT subscribe is %d\r\n", rc);
        else pc.printf("Subscribe MQTT OK topic:%s quality:%d\r\n",topic,quality);
    pc.printf("\x1B[0m"); // raz
}

void deconnection(void)
{
 int rc;
  pc.printf("\x1B[36m");   // cyan
 if ((rc = client.unsubscribe(topic)) != 0) pc.printf("rc from unsubscribe was %d\r\n", rc);
    else pc.printf("unsubscribe OK \r\n");
    if ((rc = client.disconnect()) != 0) pc.printf("rc from disconnect was %d\r\n", rc);
    else pc.printf("disconnect OK\r\n");
    mqttNetwork.disconnect();
    pc.printf("\x1B[0m"); // raz
}

int main(int argc, char* argv[])
{
    int rc;
    int cpt=0;
    char buf[100];
    
    //pc.printf("\x1B[2J");  //efface ecran
    //pc.printf("\x1B[0;0H");   // curseur en 0,0
    pc.printf("\x1B[1m");   // brillant
    pc.printf("\r\nMQTT test on %s\r\n",board);
    pc.printf("--------------------------\r\n\r\n");
    pc.printf("\x1B[33m");   // yellow
    wait(1);
  
// TCP connection
    mqttNetwork.connect(hostname, port);
    if (rc != 0) pc.printf("rc from TCP connect is %d\r\n", rc);
    else pc.printf("WIFI network connection OK\r\n");
    
// MQTT data
    data.MQTTVersion = 3;
    data.clientID.cstring = ID;
    data.username.cstring = user;
    data.password.cstring = pass;
    message.qos = quality;
    message.retained = ret;
    message.dup = dupli;
    message.payload = (void*)buf;
    connection();
    while(!quit)
    {
        pc.printf("---> Press button to send : %s<--- \n\r",topic);
        while(btn);
        while(!btn);
        //connection();
        sprintf(buf, "Message from %s number -> %d \r\n", board,++cpt);
        pc.printf("Send message -> %s\n\r",buf);
        message.payloadlen = strlen(buf)+1;
        if ((rc = client.publish(topic, message)) !=0) pc.printf("rc publication error %d\r\n", rc);
        client.yield(100);
        //deconnection();
    }

    deconnection();
    pc.printf("Disconnect from MQTT network. End of program, %d messages arrived\r\n",arrivedcount);

    return 0;
}
