/*
Christian Dupaty 03/2021
Library and demo for BMM150 see datasheet here : https://www.bosch-sensortec.com/products/motion-sensors/magnetometers-bmm150/
Adaptation of BOSCH driver https://github.com/BoschSensortec/BMM150-Sensor-API
for ARM MBED and tested on NUCLEO-L073RZ and GEOMAGNETIC CLICK
https://www.mikroe.com/geomagnetic-click 
*/

#include "mbed.h"

// libraries
#include "bmm150.h"
#include "bmm150_defs.h"
#include <math.h>
#define PI  3.141592653589793238462643383279L
#define DPI 6.283185307179586476925286766559L

// serial object for debug
Serial pc(SERIAL_TX, SERIAL_RX); // for debug
// BMM150 instance
BMM150 bmm(PB_9,PB_8);  // sda,scl in this order

void setup() {
    pc.baud(9600);

    if (bmm.initialize() == BMM150_E_ID_NOT_CONFORM) 
    {
        pc.printf("Chip ID can not be read, BMM150 not found!\n");
        while (1);      // All is lost
    } else {
        pc.printf("Initialize done, BMM150 has been founded!\n");
    }

}

int main() 
{
bmm150_mag_data value;
    setup();   // Arduino style 
    while(1)
    {
        bmm.read_mag_data();
    
        value.x = bmm.raw_mag_data.raw_datax;
        value.y = bmm.raw_mag_data.raw_datay;
        value.z = bmm.raw_mag_data.raw_dataz;
    
        double xyHeading = atan2((double)value.x, (double)value.y);
        double zxHeading = atan2((double)value.z, (double)value.x);
        double heading = xyHeading;
    
        if (heading < 0.0) 
        {
            heading += DPI;
        }
        if (heading > DPI) 
        {
            heading -= DPI;
        }
        double headingDegrees = heading * 180.0 / PI;
        double xyHeadingDegrees = xyHeading * 180.0 / PI;
        double zxHeadingDegrees = zxHeading * 180.0 / PI;
    
        pc.printf("Heading: %3.2f deg\n ",headingDegrees);

        wait_ms(1000);
    }
}