#include "mbed.h"
#include "BMA180.h"
#include "ITG3200.h"
Serial pc(USBTX, USBRX);

DigitalOut l1(LED1);
I2C I2CBus(p28, p27);
Timer GlobalTime;

#define PI             3.1415926535897932384626433832795
#define Rad2Dree       57.295779513082320876798154814105

float R;
BMA180 Acc(I2CBus, GlobalTime);
ITG3200 Gyro(I2CBus, GlobalTime);


int main() 
{
    pc.baud(9600);
  
    I2CBus.frequency(400000);
    GlobalTime.start();
//***
    Acc.Init();
    wait_ms(500);
    
    //User Calibration
    short Raw1g[3]= {0, 0, 0};
    Acc.userCalibration(Raw1g);
    
    //0.5s Calibration
    Acc.Calibrate(500, Raw1g);
//***   
    Gyro.Init();
    wait_ms(500);
    
    //0.5s Calibration
    Gyro.Calibrate(500);
//***  
    //Print the value for the Full-scale range
    pc.printf("Full-scale Range: %i \n\r", Gyro.getInfo());
    
    while(1)
    {
        //Aquire new values for the Gyro and Acc
        Acc.Update();
        Gyro.Update();
        
        //Calcuate the resulting vector R from the 3 acc axes
        R = sqrt(std::pow(Acc.Acc[0] , 2) + std::pow(Acc.Acc[1] , 2) + std::pow(Acc.Acc[2] , 2));
       
        // Print the angle in degrees of all 3 axes
        pc.printf("Angles in degrees Acc: %.6f %.6f %.6f  \n\r", 
            Rad2Dree * acos(Acc.Acc[0]/R),
            Rad2Dree * acos(Acc.Acc[1]/R),
            Rad2Dree * acos(Acc.Acc[2]/R));
            
       //Print the g-force vector on each axis in m/s^s
       /*pc.printf("BMA180:%.6f %.6f %.6f  \n\r",
            (Acc.Acc[0]),
            (Acc.Acc[1]),
            (Acc.Acc[2]));*/
        
        //Print the angular velocity in radians/sec of each axis
        /*pc.printf("Gyro:%.6f %.6f %.6f   \n\r",
            (Gyro.Rate[0]),
            (Gyro.Rate[1]),
            (Gyro.Rate[2]));*/     

        wait_ms(100);
    }
}
