#pragma once

//I2C address is either 0x68 or 0x69 , depending on pin AD0, check block diagram for your device
#define ITG3200_ADRESS 0x69

//Convert gyro raw data to radians per second, 1 degree/s = 0,017453293 rad/s.
//The value is 0,017453293/LSB (+- 250 degrees/s)

//const float fConvRPS= 2.6646248854961832061068702290076e-4; //For +- 500 degrees/s
//const float fConvRPS= 1.2141420883e-3; //For +- 2000 degrees/s

const float fConvRPS= 1.3323124427480916030534351145038e-4; //For +- 250 degrees/s

class ITG3200 {
protected:
    I2C & I2CBus;
    Timer & GlobalTime;

public:
    //Offset
    float Offset[3];

    //Rotational speed around all three axes
    short RawRate[3];       //Raw data
    float Rate[3];          //Calibrated rotation rate in radians per second


    //Initialization
    ITG3200(I2C & I2CBus_, Timer & GlobalTime_);
    void Init();


private:
    //Read raw data
    void ReadRawData();

public:
    //Update Method
    void Update();
    char getInfo(void);

    //Calibration
    void Calibrate(int ms);
};
