#pragma once

//I2C address, either 0x40 or 0x41, depending on pin VDDIO
#define BMA180_ADRESS 0x40

//Convert acceleration to meters per second squared
//This value depends on the Range you are using, i.e. +-1g, +-3g, etc.
//fConvMPSS= (acc of gravitation) / Sensitivity

const float fConvMPSS= 1.7919037e-3;

class BMA180
{
private:
    I2C & I2CBus;
    Timer & GlobalTime;
    
    //Offset
    float Offset[3];
    
public:
    //Acceleration on all three axes
    short RawAcc[3];        //Raw Data
    float Acc[3];           //Calibrated raw data in m/s^2
    
    
    //Initialization
    BMA180(I2C & I2CBus_, Timer & GlobalTime_);
    void Init();

public:    
    //Read raw Data
    void ReadRawData();
    
public:
    //Update Method
    //Get current information from the sensor
    //Calculate the offset
    //Converts other units
    void Update();
    
    //Calibration
    //pRaw1g: short array [3] provides the best raw data for approximately 1g = {0, 0, -2870}
    void Calibrate(int ms, const short * pRaw1g);
    
    void userCalibration(short * Raw1g);
};
